% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/umap.R
\name{umap}
\alias{umap}
\title{Create a umap plot; wrapper function for umap package pplus custom plotting}
\usage{
umap(
  se_object,
  assay_of_interest,
  batch,
  neighbors = 15,
  min_distance = 0.1,
  spread = 1,
  exploratory = FALSE
)
}
\arguments{
\item{se_object}{se_object; containing data of interest}

\item{assay_of_interest}{string; the assay in the se_object to plot}

\item{batch}{string; representing batch}

\item{neighbors}{integer; number of nearest neighbors, default 15 per umap;
lower values prioritize local structure, higher values will represent
bigger picture but lose finer details}

\item{min_distance}{numeric; how close points appear in final layout; higher
values puts less emphasis on global structure; must be less than spread}

\item{spread}{numeric; dispersion of points in umap}

\item{exploratory}{Boolean; default is FALSE, if True, a 5x5 grid with
k = 15, 25, 50, 100 and min_distance = 0.1, .2, .5, .75, .99 will
be plotted}
}
\value{
umap plot
}
\description{
Create a umap plot; wrapper function for umap package pplus custom plotting
}
\examples{
library(scran)
se <- mockSCE()
se$Treatment <- as.factor(se$Treatment)
se$Mutation_Status <- as.factor(se$Mutation_Status)
umap_plot <- BatchQC::umap(se_object = se, assay_of_interest = "counts",
batch = "Treatment")
umap_plot

}
