% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{cor2adj}
\alias{cor2adj}
\title{Calculate an adjacency matrix from a correlation matrix}
\usage{
cor2adj(cor_matrix, beta, net_type = "signed hybrid")
}
\arguments{
\item{cor_matrix}{A numeric, symmetric matrix with pairwise correlations
between genes (i.e., a 'correlation matrix').}

\item{beta}{Numeric scalar indicating the value of the \eqn{\beta}
power to which correlation coefficients will be raised to ensure
scale-free topology fit.}

\item{net_type}{Character indicating the type of network to infer.
Default: "signed hybrid".}
}
\value{
A numeric, symmetric matrix with network adjacency values between
genes.
}
\description{
Calculate an adjacency matrix from a correlation matrix
}
\examples{
# Simulate an expression matrix with 100 genes and 50 samples
exp <- matrix(
    rnorm(100 * 50, mean = 10, sd = 2),
    nrow = 100,
    dimnames = list(
        paste0("gene", seq_len(100)),
        paste0("sample", seq_len(50))
    )
)

# Calculate correlation matrix
cor_mat <- exp2cor(exp)

# Calculate adjacency matrix (random value for beta)
adj <- cor2adj(cor_mat, beta = 9)
}
