% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gcn_inference.R
\name{module_stability}
\alias{module_stability}
\title{Perform module stability analysis}
\usage{
module_stability(exp, net, nRuns = 20)
}
\arguments{
\item{exp}{A gene expression data frame with genes in row names and
samples in column names or a `SummarizedExperiment` object.}

\item{net}{List object returned by \code{exp2gcn}.}

\item{nRuns}{Number of times to resample. Default is 20.}
}
\value{
A base plot with the module stability results.
}
\description{
Perform module stability analysis
}
\examples{
data(filt.se)
filt <- filt.se[1:100, ] # reducing even further for testing purposes
# The SFT fit was previously calculated and the optimal power was 16
gcn <- exp2gcn(filt, SFTpower = 16, cor_method = "pearson")
# For simplicity, only 2 runs
module_stability(exp = filt, net = gcn, nRuns = 2)
}
\seealso{
\code{\link[WGCNA]{sampledBlockwiseModules}}
}
