% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filterSCE.R
\name{filterSCE}
\alias{filterSCE}
\title{\code{SingleCellExperiment} filtering}
\usage{
filterSCE(x, ..., k = NULL)
}
\arguments{
\item{x}{a \code{\link[SingleCellExperiment]{SingleCellExperiment}}.}

\item{...}{conditional statements separated by comma.
Only rows/columns where the condition evaluates to TRUE are kept.}

\item{k}{numeric or character string. Specifies the clustering to extract 
populations from. Must be one of \code{names(cluster_codes(x))}.
Defaults to the 1st clustering available.}
}
\value{
a \code{SingleCellExperiment}.
}
\description{
Filters cells/features from a \code{SingleCellExperiment} 
  using conditional statements a la \code{dplyr}.
}
\examples{
# construct SCE & run clustering
data(PBMC_fs, PBMC_panel, PBMC_md, merging_table)
sce <- prepData(PBMC_fs, PBMC_panel, PBMC_md)
sce <- cluster(sce)

# one condition only, remove a single sample
filterSCE(sce, condition == "Ref", sample_id != "Ref1")

# keep only a subset of clusters
filterSCE(sce, cluster_id \%in\% c(7, 8, 18), k = "meta20")

}
\author{
Helena L Crowell \email{helena.crowell@uzh.ch}
}
