% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotAbundances.R
\name{plotAbundances}
\alias{plotAbundances}
\title{Population frequencies across samples & clusters}
\usage{
plotAbundances(
  x,
  k = "meta20",
  by = c("sample_id", "cluster_id"),
  group_by = "condition",
  shape_by = NULL,
  col_clust = TRUE,
  distance = c("euclidean", "maximum", "manhattan", "canberra", "binary", "minkowski"),
  linkage = c("average", "ward.D", "single", "complete", "mcquitty", "median",
    "centroid", "ward.D2"),
  k_pal = .cluster_cols
)
}
\arguments{
\item{x}{a \code{\link[SingleCellExperiment]{SingleCellExperiment}}.}

\item{k}{character string specifying which clustering to use;
valid values are \code{names(cluster_codes(x))}.}

\item{by}{a character string specifying whether 
to plot frequencies by samples or clusters.}

\item{group_by}{character string specifying a non-numeric
cell metadata columnd to group by (determines the color coding);
valid values are \code{names(colData(x))} 
other than "sample_id" and "cluster_id".}

\item{shape_by}{character string specifying a non-numeric
cell metadata columnd to shape by; valid values are 
\code{names(colData(x))} other than "sample_id" and "cluster_id".}

\item{col_clust}{for \code{by = "sample_id"}, 
specifies whether to hierarchically cluster samples 
and reorder them accordingly. When \code{col_clust = FALSE}, 
samples are ordered according to \code{levels(x$sample_id)} 
(or alphabetically, when \code{x$sample_id} is not a factor).}

\item{distance}{character string specifying the distance metric 
to use for sample clustering; passed to \code{\link[stats]{dist}}}

\item{linkage}{character string specifying the agglomeration method 
to use for sample clustering; passed to \code{\link[stats]{hclust}}.}

\item{k_pal}{character string specifying the cluster 
color palette; ignored when \code{by = "cluster_id"}. 
If less than \code{nlevels(cluster_ids(x, k))} 
are supplied, colors will be interpolated via 
\code{\link[grDevices:colorRamp]{colorRampPalette}}.}
}
\value{
a \code{ggplot} object.
}
\description{
Plots the relative population abundances of the specified clustering.
}
\examples{
# construct SCE & run clustering
data(PBMC_fs, PBMC_panel, PBMC_md)
sce <- prepData(PBMC_fs, PBMC_panel, PBMC_md)
sce <- cluster(sce)

# plot relative population abundances 
# by sample & cluster, respectively
plotAbundances(sce, k = "meta12")                  
plotAbundances(sce, k = "meta8", by = "cluster_id") 

# use custom cluster color palette
plotAbundances(sce, k = "meta10", 
  k_pal = c("lightgrey", "cornflowerblue", "navy"))

}
\references{
Nowicka M, Krieg C, Crowell HL, Weber LM et al. 
CyTOF workflow: Differential discovery in 
high-throughput high-dimensional cytometry datasets.
\emph{F1000Research} 2017, 6:748 (doi: 10.12688/f1000research.11622.1)
}
\author{
Helena L Crowell \email{helena.crowell@uzh.ch}
}
