% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepData.R
\name{prepData}
\alias{prepData}
\title{Data preparation}
\usage{
prepData(
  x,
  panel = NULL,
  md = NULL,
  features = NULL,
  transform = TRUE,
  cofactor = 5,
  panel_cols = list(channel = "fcs_colname", antigen = "antigen", class = "marker_class"),
  md_cols = list(file = "file_name", id = "sample_id", factors = c("condition",
    "patient_id")),
  by_time = TRUE,
  FACS = FALSE,
  fix_chs = c("common", "all"),
  ...
)
}
\arguments{
\item{x}{a \code{flowSet} holding all samples 
or a path to a set of FCS files.}

\item{panel}{a data.frame containing, for each channel, 
its column name in the input data, targeted protein marker,
and (optionally) class ("type", "state", or "none").
If `panel` is unspecified, it will be constructed 
from the first input sample via \code{\link{guessPanel}}.}

\item{md}{a table with column describing the experiment.
An exemplary metadata table could look as follows: \itemize{
\item\code{file_name}: the FCS file name
\item\code{sample_id}: a unique sample identifier
\item\code{patient_id}: the patient ID
\item\code{condition}: brief sample description 
  (e.g. reference/stimulated, healthy/diseased)}
If `md` is unspecified, the \code{flowFrame/Set} 
\code{\link[flowCore:identifier-methods]{identifier}}(s) 
will be used as sample IDs with no additional metadata factors.}

\item{features}{a logical vector, numeric vector of column indices,
or character vector of channel names. Specified which column to keep 
from the input data. Defaults to the channels listed in the input panel.}

\item{transform}{logical. Specifies whether an arcsinh-transformation with 
cofactor cofactor should be performed, in which case expression values 
(transformed counts) will be stored in assay(x, "exprs").}

\item{cofactor}{numeric cofactor(s) to use for optional 
arcsinh-transformation when \code{transform = TRUE};
single value or a vector with channels as names.}

\item{panel_cols}{a names list specifying 
the \code{panel} column names that contain channel names, 
targeted protein markers, and (optionally) marker classes. 
When only some \code{panel_cols} deviate from the defaults,
specifying only these is sufficient.}

\item{md_cols}{a named list specifying the column names of \code{md}
that contain the FCS file names, sample IDs, and factors of interest
(batch, condition, treatment etc.). When only some \code{md_cols} deviate 
from the defaults, specifying only these is sufficient.}

\item{by_time}{logical; should samples be ordered by acquisition time? 
Ignored if \code{!is.null(md)} in which case samples will be ordered 
as they are listed in \code{md[[md_cols$file]]}. (see details)}

\item{FACS}{logical; is this FACS / flow cytometry data? 
By default, \code{prepData} moves non-mass channels to 
the output SCE's \code{int_colData}; \code{FACS = TRUE} 
assures that all channels are kept as \code{assay} data.
If \code{FALSE}, \code{prepData} will try and access 
the input \code{flowFrame/Set}'s \code{"$CYT"} descriptor 
(\code{keyword(., "$CYT")}) to determine the data type; 
this may be inaccurate for some cytometer descriptors.}

\item{fix_chs}{specifies the strategy to use in case of panel discrepancies.
\code{"common"} will retain only channels present in all frames/FCS files;
\code{"all"} will retain the union of channels across samples. In the 
latter case, a logical matrix with rows = channels and columns = samples 
will be stored under \code{metadata} slot \code{chs_by_fcs} specifying 
which channels were/n't (\code{FALSE/TRUE}) measured in which samples.}

\item{...}{additional arguments passed to \code{\link{read.FCS}}. 
E.g., \code{channel_alias} in case of panel discrepancies between frames/
FCS files. By default, \code{transformation = truncate_max_range = FALSE}.}
}
\value{
a \code{\link[SingleCellExperiment]{SingleCellExperiment}}.
}
\description{
Data preparation
}
\details{
By default, non-mass channels (e.g., time, event lengths) will be removed 
from the output SCE's assay data and instead stored in the object's internal 
cell metadata (\code{int_colData}) to assure these data are not subject to 
transformations or other computations applied to the assay data.

For more than 1 sample, \code{prepData} will concatenate cells into a single 
\code{SingleCellExperiment} object. Note that cells will hereby be order by 
\code{"Time"}, regardless of whether \code{by_time = TRUE} or \code{FALSE}. 
Instead, \code{by_time} determines the sample (not cell!) order; 
i.e., whether samples should be kept in their original order, 
or should be re-ordered according to their acquision time 
stored in \code{keyword(flowSet, "$BTIM")}.

When a metadata table is specified (i.e. \code{!is.null(md)}), 
argument \code{by_time} will be ignored and sample ordering 
is instead determined by \code{md[[md_cols$file]]}.
}
\examples{
data(PBMC_fs, PBMC_panel, PBMC_md)
prepData(PBMC_fs, PBMC_panel, PBMC_md)

# channel-specific transformation
cf <- sample(seq_len(10)[-1], nrow(PBMC_panel), TRUE)
names(cf) <- PBMC_panel$fcs_colname
sce <- prepData(PBMC_fs, cofactor = cf)
int_metadata(sce)$cofactor

# input has different name for "condition"
md <- PBMC_md
m <- match("condition", names(md))
colnames(md)[m] <- "treatment"

# add additional factor variable batch ID
md$batch_id <- sample(c("A", "B"), nrow(md), TRUE)

# specify 'md_cols' that differ from defaults
factors <- list(factors = c("treatment", "batch_id"))
ei(prepData(PBMC_fs, PBMC_panel, md, md_cols = factors))

# without panel & metadata tables
sce <- prepData(raw_data)

# 'flowFrame' identifiers are used as sample IDs
levels(sce$sample_id)

# panel was guess with 'guessPanel';
# non-mass channels are set to marker class "none"
rowData(sce)

}
\author{
Helena L Crowell \email{helena.crowell@uzh.ch}
}
