% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichment.R
\name{mod_ora}
\alias{mod_ora}
\alias{mod_ora,CEMiTool-method}
\title{Module Overrepresentation Analysis}
\usage{
mod_ora(cem, ...)

\S4method{mod_ora}{CEMiTool}(cem, gmt, verbose = FALSE)
}
\arguments{
\item{cem}{Object of class \code{CEMiTool}.}

\item{...}{Optional parameters.}

\item{gmt}{Object of class \code{data.frame} with 2 columns, one with
pathways and one with genes}

\item{verbose}{logical. Report analysis steps.}
}
\value{
Object of class \code{CEMiTool}
}
\description{
Performs overrepresentation analysis for each co-expression module found.
}
\examples{
# Get example CEMiTool object
data(cem)
# Read gmt file
gmt <- read_gmt(system.file('extdata', 'pathways.gmt',
                   package='CEMiTool'))
# Run module overrepresentation analysis
cem <- mod_ora(cem, gmt)
# Check results
head(ora_data(cem))

}
\seealso{
\code{\link{ora_data}}
}
