% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_enrichment.R
\name{plot_enrichment}
\alias{plot_enrichment}
\title{Generate enrichment analysis plots}
\usage{
plot_enrichment(
  peaklist,
  txdb = NULL,
  tss_distance = c(-3000, 3000),
  pvalueCutoff = 0.05,
  interact = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{peaklist}{A list of peak files as GRanges object.
Files must be listed and named using \code{list()}.
e.g. \code{list("name1"=file1, "name2"=file2)}.
If not named, default file names will be assigned.}

\item{txdb}{A TxDb annotation object from Bioconductor.}

\item{tss_distance}{A vector specifying the distance upstream and downstream
around transcription start sites (TSS). 
The default value is \code{c(-3000,3000)}; meaning peak frequency 
3000bp upstream and downstream of TSS will be displayed.}

\item{pvalueCutoff}{P-value cutoff,
passed to \link[clusterProfiler]{compareCluster}.}

\item{interact}{Default TRUE. By default, plots are interactive.
If set FALSE, all plots in the report will be static.}

\item{verbose}{Print messages.}
}
\value{
KEGG and GO dot plots
}
\description{
This function runs KEGG and GO enrichment analysis of peak files
and generates dot plots.
}
\examples{
### Load Data ###
data("CnT_H3K27ac") # example peakfile GRanges object
data("CnR_H3K27ac") # example peakfile GRanges object 
### Create Named Peaklist ###
peaklist <- list("CnT"=CnT_H3K27ac, "CnR"=CnR_H3K27ac) 
enrich_res <- plot_enrichment(peaklist = peaklist, pvalueCutoff=1,
                              tss_distance = c(-50,50)) 
}
