% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gtoxLoadClib.R
\name{gtoxLoadClib}
\alias{gtoxLoadClib}
\title{Load chemical library information}
\usage{
gtoxLoadClib(field = NULL, val = NULL)
}
\arguments{
\item{field}{Character of length 1, \code{'chid'} or \code{'clib'}, whether
to search by chemical id (chid), or chemical library (clib)}

\item{val}{The values to query on}
}
\value{
A data.table with the chemical library information for the given
parameters.
}
\description{
\code{gtoxLoadClib} queries the gtox databases and returns information
about the chemial library.
}
\details{
Chemicals are stored in different libraries by chemcial ID. Therefore, it
is not possible to delineate samples with the same chemical ID into two
distinct chemical libraries. However, it is possible for a chemcial ID to
belong to more than one (or no) chemical libraries.

When chemicals belong to more than one library, the chemical is listed
multiple times (one for each distinct library).
}
\examples{
## Store the current config settings, so they can be reloaded at the end
## of the examples
conf_store <- gtoxConfList()
gtoxConfDefault()

## Passing no parameters gives all of the chemical ISs that have a chemical
## library registered
clib <- gtoxLoadClib()

## Reset configuration
options(conf_store)

}
