% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\name{HiCDOCDataSetFromHiC}
\alias{HiCDOCDataSetFromHiC}
\title{\code{\link{HiCDOCDataSet}} constructor from HiC files.}
\usage{
HiCDOCDataSetFromHiC(paths, replicates, conditions, binSize)
}
\arguments{
\item{paths}{A vector of paths to \code{.hic} files.}

\item{replicates}{A vector of replicate names repeated along the conditions.}

\item{conditions}{A vector of condition names repeated along the replicates.}

\item{binSize}{The resolution (span of each position in number of bases) to select within
the \code{.hic} files.}
}
\value{
A \code{\link{HiCDOCDataSet}}.
}
\description{
Constructs a \code{\link{HiCDOCDataSet}} from a set of
\code{.hic} files.
}
\examples{
\dontrun{
    #' # Path to each file
    paths = c(
      'path/to/condition-1.replicate-1.hic',
      'path/to/condition-1.replicate-2.hic',
      'path/to/condition-2.replicate-1.hic',
      'path/to/condition-2.replicate-2.hic',
      'path/to/condition-3.replicate-1.hic'
    )

    # Replicate and condition of each file. Can be names instead of numbers.
    replicates <- c(1, 2, 1, 2, 1)
    conditions <- c(1, 1, 2, 2, 3)

    # Resolution to select
    binSize <- 500000

    # Instantiation of data set
    hic.experiment <- HiCDOCDataSetFromHiC(
      paths,
      replicates = replicates,
      conditions = conditions,
      binSize = binSize
    )
}

}
