% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/show-methods.R
\docType{class}
\name{FunctionalEnrichment-class}
\alias{FunctionalEnrichment-class}
\alias{FunctionalEnrichment}
\alias{enrichmentResults,FunctionalEnrichment-method}
\alias{enrichmentDatabase,FunctionalEnrichment-method}
\alias{enrichmentMethod,FunctionalEnrichment-method}
\alias{geneSet,FunctionalEnrichment-method}
\alias{enrichmentMetric,FunctionalEnrichment-method}
\alias{enrichedFeatures,FunctionalEnrichment-method}
\alias{show,FunctionalEnrichment-method}
\title{The \code{FunctionalEnrichment} class}
\usage{
\S4method{enrichmentResults}{FunctionalEnrichment}(object)

\S4method{enrichmentDatabase}{FunctionalEnrichment}(object)

\S4method{enrichmentMethod}{FunctionalEnrichment}(object)

\S4method{geneSet}{FunctionalEnrichment}(object)

\S4method{enrichmentMetric}{FunctionalEnrichment}(object)

\S4method{enrichedFeatures}{FunctionalEnrichment}(object)

\S4method{show}{FunctionalEnrichment}(object)
}
\arguments{
\item{object}{An object of class
\code{\link[=FunctionalEnrichment-class]{FunctionalEnrichment}} containing
enrichment results}
}
\value{
\itemize{
\item the \code{enrichmentResults()} function returns a \code{data.frame} object
with the results of the functional enrichment analysis.
}

\itemize{
\item the \code{enrichmentDatabase()} function returns a \code{character} that
specifies the database that provided the gene-set collection.
}

\itemize{
\item the \code{enrichmentMethod()} function returns a \code{character} with the
enrichment method used for the analysis.
}

\itemize{
\item the \code{geneSet()} function returns a \code{list} with the
gene-set collections retrieved.
}

\itemize{
\item the \code{enrichmentMetric()} function returns a \code{numeric} object with
ranked gene statistic used for GSEA.
}

\itemize{
\item the \code{enrichmentMetric()} function returns a \code{character} object with
the names of the ranked features used for GSEA.
}
}
\description{
This class introduces the possibility to store the results of functional
enrichment analyses such as over-representation analysis (ORA), gene set
enrichment analysis (GSEA), and competitive gene set test accounting for
inter-gene correlation (CAMERA). The different slots contained in this class
are used to store enrichment results generated through the \code{\link[=enrichGenes]{enrichGenes()}}
function.
}
\section{Functions}{
\itemize{
\item \code{enrichmentResults(FunctionalEnrichment)}: Access the \code{data} slot to take a
closer look at all the enriched terms of an enrichment analysis

\item \code{enrichmentDatabase(FunctionalEnrichment)}: See the database used for the
functional enrichment

\item \code{enrichmentMethod(FunctionalEnrichment)}: Visualize the approach used for the
functional enrichment analysis

\item \code{geneSet(FunctionalEnrichment)}: Access the \code{geneSet} slot to see
the collection of gene sets used for GSEA

\item \code{enrichmentMetric(FunctionalEnrichment)}: View the ranking metric used for GSEA

\item \code{enrichedFeatures(FunctionalEnrichment)}: View the names of the pre-ranked
features used for GSEA

\item \code{show(FunctionalEnrichment)}: Show method for objects of
class FunctionalEnrichment

}}
\section{Slots}{

\describe{
\item{\code{data}}{A \code{data.frame} object holding the output of enrichment analysis}

\item{\code{method}}{The method used to perform functional enrichment analysis
(e.g. \verb{Gene Set Enrichment Analysis (GSEA)})}

\item{\code{organism}}{The name of the organism under consideration (e.g.
\verb{Homo sapiens})}

\item{\code{database}}{The name of the database used for the enrichment analysis
(e.g. \code{KEGG})}

\item{\code{pCutoff}}{A \code{numeric} value defining the threshold used for
statistical significance in the enrichment analysis (e.g. \code{0.05})}

\item{\code{pAdjustment}}{A \code{character} indicating the method used to correct
p-values for multiple testing (e.g. \code{fdr})}

\item{\code{features}}{A \code{character} vector containing the list of features used for
the enrichment}

\item{\code{statistic}}{A \code{numeric} vector containing the statistic used to run
GSEA. This parameter is empty for ORA and CAMERA}

\item{\code{universe}}{The background universe of features. Typically, this is equal
to the complete list of features assayed. This slot is NULL for GSEA}

\item{\code{geneSet}}{The gene set used for the functional enrichment analysis. It
is a \code{list} object where each element contains the list of genes belonging
to a specific pathway.}
}}

\author{
Jacopo Ronchi, \email{jacopo.ronchi@unimib.it}
}
