% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R
\name{augmentedPathways}
\alias{augmentedPathways}
\title{Access the miRNA-augmented pathways that were used during TAIPA}
\usage{
augmentedPathways(object)
}
\arguments{
\item{object}{An object of class
\code{\link[=IntegrativePathwayAnalysis-class]{IntegrativePathwayAnalysis}} containing
the results of a miRNA-mRNA pathway analysis}
}
\value{
A \code{list} object with the miRNA-augmented biological pathways.
}
\description{
This function accesses the \code{pathways} slot of a
\code{\link[=FunctionalEnrichment-class]{FunctionalEnrichment}} object and returns
a \code{list} object with the augmented pathways that were considered by the
\code{\link[=topologicalAnalysis]{topologicalAnalysis()}} function to perform the integrative analysis.
}
\examples{
# load the example IntegrativePathwayAnalysis object
obj <- loadExamples("IntegrativePathwayAnalysis")

# extract the pathways
ps <- augmentedPathways(obj)

}
\author{
Jacopo Ronchi, \email{jacopo.ronchi@unimib.it}
}
