% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{gseaRidgeplot}
\alias{gseaRidgeplot}
\title{Create a ridgeplot to display the results of GSEA analysis}
\usage{
gseaRidgeplot(
  enrichment,
  showTerms = 10,
  showTermsParam = "padj",
  title = NULL
)
}
\arguments{
\item{enrichment}{An object of class
\code{\link[=FunctionalEnrichment-class]{FunctionalEnrichment}} containing
enrichment results}

\item{showTerms}{It is the number of terms to be shown, based on the
order determined by the parameter \code{showTermsParam}; or, alternatively, a
character vector indicating the terms to plot. Default is \code{10}}

\item{showTermsParam}{The order in which the top terms are selected as
specified by the \code{showTerms} parameter. It must be one of \code{ratio}, \code{padj}
(default), \code{pval} and \code{overlap}}

\item{title}{The title of the plot. Default is \code{NULL} not to include a plot
title}
}
\value{
An object of class \code{ggplot} containing the ridgeplot of GSEA results.
}
\description{
This function creates a ridgeplot that is useful for showing the results
of GSEA analyses. The output of this function is a plot where enriched
terms/pathways found with \code{\link[=enrichGenes]{enrichGenes()}} function are visualized on the
basis of the ranking metric used for the analysis. The resulting
areas represent the density of signed p-values, log2 fold changes, or
log.p-values belonging to genes annotated to that category.
}
\examples{
# load example FunctionalEnrichment object
obj <- loadExamples("FunctionalEnrichment")

# plot results
gseaRidgeplot(obj)

}
\author{
Jacopo Ronchi, \email{jacopo.ronchi@unimib.it}
}
