% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{integrationDotplot}
\alias{integrationDotplot}
\title{Display integrated miRNA-mRNA augmented pathways in a dotplot}
\usage{
integrationDotplot(
  object,
  showTerms = 10,
  showTermsParam = "normalized.score",
  title = NULL
)
}
\arguments{
\item{object}{An object of class
\code{\link[=IntegrativePathwayAnalysis-class]{IntegrativePathwayAnalysis}}}

\item{showTerms}{It is the number of pathways to be shown, based on the
order determined by the parameter \code{showTermsParam}; or, alternatively, a
character vector indicating the pathways to plot. Default is \code{10}}

\item{showTermsParam}{The order in which the top pathways are selected as
specified by the \code{showTerms} parameter. It must be one of \code{coverage},
\code{padj}, \code{pval}, \code{score} and \code{normalized.score} (default)}

\item{title}{The title of the plot. Default is \code{NULL} not to include a plot
title}
}
\value{
A \code{ggplot} graph with a dotplot of integrated pathways.
}
\description{
This function produces a dotplot that depicts the results of a
topologically-aware integrative pathway analysis (TAIPA) carried out through
the \code{\link[=topologicalAnalysis]{topologicalAnalysis()}} function.
}
\details{
When producing the dotplot with this function, significant pathways
are ordered on the x-axis on the basis of their normalized pathway score
computed by \code{\link[=topologicalAnalysis]{topologicalAnalysis()}}. The higher is this score, and the more
affected a pathway is between biological conditions. Moreover, the size
of each dot is equal to the ratio between the number of nodes for which a
measurement is available, and the total number of nodes (pathway coverage).
Finally, the color scale of dots is relative to the adjusted p-values of
each pathway.
}
\examples{
# load example IntegrativePathwayAnalysis object
obj <- loadExamples("IntegrativePathwayAnalysis")

# create a dotplot of integrated pathways
integrationDotplot(obj)

}
\author{
Jacopo Ronchi, \email{jacopo.ronchi@unimib.it}
}
