% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{mirVariantPlot}
\alias{mirVariantPlot}
\title{Create a trackplot to show the association between miRNAs and disease-SNPs}
\usage{
mirVariantPlot(
  variantId,
  snpAssociation,
  showContext = FALSE,
  showSequence = TRUE,
  snpFill = "lightblue",
  mirFill = "orange",
  from = NULL,
  to = NULL,
  title = NULL,
  ...
)
}
\arguments{
\item{variantId}{A valid name of a SNP variant! (e.g. \code{"rs394581"})}

\item{snpAssociation}{A \code{data.frame} object containing the results of
\code{\link[=findMirnaSNPs]{findMirnaSNPs()}} function}

\item{showContext}{Logical, if \code{TRUE} a complete genomic context with genes
present in the region will be shown. Default is \code{FALSE} to just display the
variant and the miRNA gene}

\item{showSequence}{Logical, whether to display a color-coded sequence at
the bottom of the trackplot. Default is \code{TRUE}. This parameter will be set
to \code{FALSE} if \code{showContext} is \code{TRUE}}

\item{snpFill}{It must be an R color name that specifies the fill color of
the SNP locus. Default is \code{lightblue}. Available color formats include
color names, such as 'blue' and 'red', and hexadecimal colors specified
as #RRGGBB}

\item{mirFill}{It must be an R color name that specifies the fill color of
the miRNA locus. Default is \code{orange}. Available color formats include
color names, such as 'blue' and 'red', and hexadecimal colors specified
as #RRGGBB}

\item{from}{The start position of the plotted genomic range. Default is
NULL to automatically determine an appropriate position}

\item{to}{The end position of the plotted genomic range. Default is
NULL to automatically determine an appropriate position}

\item{title}{The title of the plot. Default is \code{NULL} not to include a plot
title}

\item{...}{Other parameters that can be passed to \code{\link[Gviz:plotTracks]{Gviz::plotTracks()}}
function}
}
\value{
A trackplot with information about chromosome, SNP and miRNA gene location.
}
\description{
This function plots a trackplot that shows the genomic position of
disease-associated SNPs that affect miRNA genes. This is useful to visualize
the genomic position and context of disease-associated variants that may
affect miRNA expression.
}
\note{
This function retrieves genomic coordinates from the output of
\code{\link[=findMirnaSNPs]{findMirnaSNPs()}} function and then uses \code{Gviz} package to build
the trackplot.
}
\examples{

\donttest{
# load example MirnaExperiment object
obj <- loadExamples()

# retrieve associated SNPs
association <- findMirnaSNPs(obj, "response to antidepressant")

# visualize association as a trackplot
mirVariantPlot(variantId = "rs2402960", snpAssociation = association)
}

}
\references{
Hahne, F., Ivanek, R. (2016). Visualizing Genomic Data Using Gviz and
Bioconductor. In: Mathé, E., Davis, S. (eds) Statistical Genomics. Methods
in Molecular Biology, vol 1418. Humana Press, New York, NY.
\url{https://doi.org/10.1007/978-1-4939-3578-9_16}
}
\author{
Jacopo Ronchi, \email{jacopo.ronchi@unimib.it}
}
