% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCAPlotLiP.R
\name{PCAPlotLiP}
\alias{PCAPlotLiP}
\title{Visualize PCA analysis for LiP and TrP datasets.}
\usage{
PCAPlotLiP(
  data,
  center.pca = TRUE,
  scale.pca = TRUE,
  n.components = 10,
  bar.plot = TRUE,
  protein.pca = TRUE,
  comparison.pca = FALSE,
  which.pep = "all",
  which.comparison = "all",
  width = 10,
  height = 10,
  address = ""
)
}
\arguments{
\item{data}{data name of the list with LiP and (optionally) Protein data, which
can be the output of the MSstatsLiP.
\code{\link[MSstatsLiP]{dataSummarizationLiP}} function.}

\item{center.pca}{a logical value indicating whether the variables should be
shifted to be zero centered. Alternately, a vector of length equal the number
of columns of x can be supplied. The value is passed to scale}

\item{scale.pca}{a logical value indicating whether the variables should be
scaled to have unit variance before the analysis takes place. The default is
FALSE for consistency with S, but in general scaling is advisable.
Alternatively, a vector of length equal the number of columns of x can be
supplied. The value is passed to scale.}

\item{n.components}{an integer of PCA components to be returned. Default is
10.}

\item{bar.plot}{a logical value indicating if to visualize PCA bar plot}

\item{protein.pca}{a logical value indicating if to visualize PCA peptide
plot}

\item{comparison.pca}{a logical value indicating if to visualize PCA
comparison plot}

\item{which.pep}{a list of peptides to be visualized. Default is "all". If
too many peptides are plotted the names can overlap.}

\item{which.comparison}{a list of comparisons to be visualized. Default is
"all".}

\item{width}{width of the saved file. Default is 10.}

\item{height}{height of the saved file. Default is 10.}

\item{address}{the name of folder that will store the results. Default
folder is the current working directory. The other assigned folder has to
be existed under the current working directory. An output pdf file is
automatically created with the default name of "VolcanoPlot.pdf" or
"Heatmap.pdf". The command address can help to specify where to store the
file as well as how to modify the beginning of the file name. If
address=FALSE, plot will be not saved as pdf file but showed in window}
}
\value{
plot or pdf
}
\description{
Takes as input LiP and TrP data from summarization function
dataSummarizationLiP. Runs PCA on the summarized data. Can visualize the PCA
analysis in three different plots:
(1) BarPlot (specify "bar.plot=TRUE" in option bar.plot), to plot a bar plot
showing the explained variance per PCA component
(2) Peptide/Protein PCA (specify "protein.pca = TRUE" in option protein.pca),
to create a dot plot with PCA component 1 and 2 on the axis, for different
peptides and proteins.
(3) Comparison PCA (specify "comparison.pca = TRUE" in option comparison.pca)
, to create a arrow plot with PCA component 1 and 2 on the axis, for
different comparisons
}
\examples{
# Use output of dataSummarizationLiP function

# BarPlot
PCAPlotLiP(MSstatsLiP_Summarized, bar.plot = TRUE, protein.pca = FALSE)

# Protein/Peptide PCA Plot
PCAPlotLiP(MSstatsLiP_Summarized, bar.plot = FALSE, protein.pca = TRUE)

# Condition PCA Plot
PCAPlotLiP(MSstatsLiP_Summarized, bar.plot = FALSE, protein.pca = FALSE,
           comparison.pca = TRUE)

}
