% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StructuralBarcodePlotLiP.R
\name{StructuralBarcodePlotLiP}
\alias{StructuralBarcodePlotLiP}
\title{Barcode plot. Shows protein coverge of LiP modified peptides.}
\usage{
StructuralBarcodePlotLiP(
  data,
  fasta,
  model_type = "Adjusted",
  which.prot = "all",
  which.comp = "all",
  adj.pvalue.cutoff = 0.05,
  FC.cutoff = 0,
  FT.only = FALSE,
  width = 12,
  height = 4,
  address = ""
)
}
\arguments{
\item{data}{list of data.tables containing LiP and TrP data in MSstatsLiP
format. Should be output of modeling function such as
\code{\link[MSstatsLiP]{groupComparisonLiP}}.}

\item{fasta}{A string of path to a FASTA file}

\item{model_type}{A string of either "Adjusted" or "Unadjusted", indicating
whether to plot the adjusted or unadjusted models. Default is "Adjusted".}

\item{which.prot}{a list of peptides to be visualized. Default is "all" which
will plot a separate barcode plot for each protein.}

\item{which.comp}{a list of comparisons to be visualized. Default is "all"
which will plot a separate barcode plot for each comparison and protein.}

\item{adj.pvalue.cutoff}{Default is .05. Alpha value for testing significance
of model output.}

\item{FC.cutoff}{Default is 0. Minimum absolute FC before a comparison will
be considered significant.}

\item{FT.only}{FALSE plots all FT and HT peptides, TRUE plots FT peptides
only. Default is FALSE.}

\item{width}{width of the saved file. Default is 10.}

\item{height}{height of the saved file. Default is 10.}

\item{address}{the name of folder that will store the results. Default
folder is the current working directory. The other assigned folder has to
be existed under the current working directory. An output pdf file is
automatically created with the default name of "VolcanoPlot.pdf" or
"Heatmap.pdf". The command address can help to specify where to store the
file as well as how to modify the beginning of the file name. If
address=FALSE, plot will be not saved as pdf file but showed in window}
}
\value{
plot or pdf
}
\description{
Barcode plot. Shows protein coverge of LiP modified peptides.
}
\examples{
# Specify Fasta path
fasta_path <- system.file("extdata", "ExampleFastaFile.fasta", package="MSstatsLiP")

# Use model data to create Barcode Plot
StructuralBarcodePlotLiP(MSstatsLiP_model, fasta_path,
                         model_type = "Adjusted",
                         address=FALSE)

}
