% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_plots.R
\name{RiboQC.plot}
\alias{RiboQC.plot}
\title{Quality control for pshifted Ribo-seq data}
\usage{
RiboQC.plot(
  df,
  output.dir = QCfolder(df),
  width = 6.6,
  height = 4.5,
  plot.ext = ".pdf",
  type = "pshifted",
  weight = "score",
  bar.position = "dodge",
  as_gg_list = FALSE,
  BPPARAM = BiocParallel::SerialParam(progressbar = TRUE)
)
}
\arguments{
\item{df}{an ORFik \code{\link{experiment}}}

\item{output.dir}{NULL or character path, default: NULL, plot not saved to disc.
If defined saves plot to that directory with the name "/STATS_plot.pdf".}

\item{width}{width of plot, default 6.6 (in inches)}

\item{height}{height of plot, default 4.5 (in inches)}

\item{plot.ext}{character, default: ".pdf". Alternatives: ".png" or ".jpg".}

\item{type}{type of library loaded, default pshifted,
warning if not pshifted might crash if too many read lengths!}

\item{weight}{which column in reads describe duplicates, default "score".}

\item{bar.position}{character, default "dodge". Should Ribo-seq frames
per read length be positioned as "dodge" or "stack" (on top of each other).}

\item{as_gg_list}{logical, default FALSE. Return as a list of ggplot objects
instead of as a grob. Gives you the ability to modify plots more directly.}

\item{BPPARAM}{how many cores/threads to use? default: bpparam().
To see number of threads used, do \code{bpparam()$workers}.
You can also add a time remaining bar, for a more detailed pipeline.}
}
\value{
the plot object, a grob of ggplot objects of the the data
}
\description{
Combines several statistics from the pshifted reads into a plot:\cr
-1 Coding frame distribution per read length\cr
-2 Alignment statistics\cr
-3 Biotype of non-exonic pshifted reads\cr
-4 mRNA localization of pshifted reads\cr
}
\examples{
df <- ORFik.template.experiment()
df <- df[9,] #lets only p-shift RFP sample at index 9
#shiftFootprintsByExperiment(df)
#RiboQC.plot(df, tempdir())
}
