% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_format_conversion.R
\name{convert_to_fstWig}
\alias{convert_to_fstWig}
\title{Convert to fstwig}
\usage{
convert_to_fstWig(
  df,
  in_files = filepath(df, "pshifted"),
  out_dir = file.path(libFolder(df), "fstwig"),
  split.by.strand = TRUE,
  split.by.readlength = FALSE,
  seq_info = seqinfo(df),
  weight = "score",
  is_pre_collapsed = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{df}{an ORFik \code{\link{experiment}}, or NULL is allowed if
both in_files and out_dir is specified manually.}

\item{in_files}{paths to input files, default pshifted files:
\code{filepath(df, "pshifted")} in ofst format}

\item{out_dir}{paths to output files, default
\code{file.path(libFolder(df), "bigwig")}.}

\item{split.by.strand}{logical, default TRUE, split into forward and reverse
strand RleList inside covRle object.}

\item{split.by.readlength}{logical, default FALSE, split into files
for each readlength, defined by readWidths(x) for each file.}

\item{seq_info}{SeqInfo object, default \code{seqinfo(findFa(df))}}

\item{weight}{integer, numeric or single length character. Default "score".
Use score column in loaded in_files.}

\item{is_pre_collapsed}{logical, default FALSE. Have you already
collapsed reads with collapse.by.scores,
so each positions is only in 1 GRanges object with
a score column per readlength?
Set to TRUE, only if you are sure, will give a speedup.}

\item{verbose}{logical, default TRUE, message about library output status.}
}
\value{
invisible(NULL), files saved to disc
}
\description{
Will split files by chromosome for faster loading for now.
This feature might change in the future!
}
