% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_helpers.R
\name{countOverlapsW}
\alias{countOverlapsW}
\title{CountOverlaps with weights}
\usage{
countOverlapsW(query, subject, weight = NULL, ...)
}
\arguments{
\item{query}{IRanges, IRangesList, GRanges, GRangesList object.
Usually transcript a transcript region.}

\item{subject}{GRanges, GRangesList, GAlignment or covRle, usually reads.}

\item{weight}{(default: NULL), if defined either numeric or character name
of valid meta column in subject. If weight is single numeric, it is used
for all. A normall weight is the score column given as weight = "score".
GRanges("chr1", 1, "+", score = 5), would mean score column tells
that this alignment region was found 5 times. Ignored if subject is covRle.}

\item{...}{additional arguments passed to countOverlaps/findOverlaps}
}
\value{
a named vector of number of overlaps to subject weigthed
 by 'weight' column.
}
\description{
Similar to countOverlaps, but takes an optional weight column.
This is usually the score column
}
\examples{
gr1 <- GRanges(seqnames="chr1",
               ranges=IRanges(start = c(4, 9, 10, 30),
                              end = c(4, 15, 20, 31)),
               strand="+")
gr2 <- GRanges(seqnames="chr1",
               ranges=IRanges(start = c(1, 4, 15, 25),
                              end = c(2, 4, 20, 26)),
               strand=c("+"),
               score=c(10, 20, 15, 5))
countOverlaps(gr1, gr2)
countOverlapsW(gr1, gr2, weight = "score")
}
\seealso{
Other features: 
\code{\link{computeFeatures}()},
\code{\link{computeFeaturesCage}()},
\code{\link{disengagementScore}()},
\code{\link{distToCds}()},
\code{\link{distToTSS}()},
\code{\link{entropy}()},
\code{\link{floss}()},
\code{\link{fpkm}()},
\code{\link{fpkm_calc}()},
\code{\link{fractionLength}()},
\code{\link{initiationScore}()},
\code{\link{insideOutsideORF}()},
\code{\link{isInFrame}()},
\code{\link{isOverlapping}()},
\code{\link{kozakSequenceScore}()},
\code{\link{orfScore}()},
\code{\link{rankOrder}()},
\code{\link{ribosomeReleaseScore}()},
\code{\link{ribosomeStallingScore}()},
\code{\link{startRegion}()},
\code{\link{startRegionCoverage}()},
\code{\link{stopRegion}()},
\code{\link{subsetCoverage}()},
\code{\link{translationalEff}()}
}
\concept{features}
