% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gr_positions.R
\name{downstreamFromPerGroup}
\alias{downstreamFromPerGroup}
\title{Get rest of objects downstream (inclusive)}
\usage{
downstreamFromPerGroup(
  tx,
  downstreamFrom,
  is.circular = all(isCircular(tx) \%in\% TRUE)
)
}
\arguments{
\item{tx}{a \code{\link{GRangesList}},
usually of Transcripts to be changed}

\item{downstreamFrom}{a vector of integers, for each group in tx, where
is the new start point of first valid exon.}

\item{is.circular}{logical, default FALSE if not any is: all(isCircular(grl) %in% TRUE).
Where grl is the ranges checked. If TRUE, allow ranges to extend
below position 1 on chromosome. Since circular genomes can have negative coordinates.}
}
\value{
a GRangesList of downstream part
}
\description{
Per group get the part downstream of position.
downstreamFromPerGroup(tx, startSites(threeUTRs, asGR = TRUE))
will return the  3' utrs per transcript as GRangesList,
usually used for interesting
parts of the transcripts.
}
\details{
If you don't want to include the points given in the region,
use \code{\link{downstreamOfPerGroup}}
}
\seealso{
Other GRanges: 
\code{\link{assignFirstExonsStartSite}()},
\code{\link{assignLastExonsStopSite}()},
\code{\link{downstreamOfPerGroup}()},
\code{\link{upstreamFromPerGroup}()},
\code{\link{upstreamOfPerGroup}()}
}
\concept{GRanges}
\keyword{internal}
