% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SRA_metadata.R
\name{get_bioproject_candidates}
\alias{get_bioproject_candidates}
\title{Query eutils for bioproject IDs}
\usage{
get_bioproject_candidates(
  term = "Ribosome Profiling human",
  as_accession = TRUE,
  add_study_title = FALSE,
  RetMax = 10000
)
}
\arguments{
\item{term}{character, default "Ribosome Profiling human".
A space is translated into AND, that means "Ribosome AND Profiling AND human",
will give same as above. To do OR operation, do:
"Ribosome OR profiling OR human".}

\item{as_accession}{logical, default TRUE. Get bioproject accessions:
PRJNA, PRJEB, PRJDB values, or IDs (FALSE), numbers only. Accessions
are usually the thing needed for most tools.}

\item{add_study_title}{logical, default FALSE. If TRUE, return as data table
with 2 columns: id: ID or accessions. title: The title of the study.}

\item{RetMax}{integer, default 10000. How many IDs to return maximum}
}
\value{
character vector of Accessions or IDs. If add_study_title is TRUE,
returns a data.table.
}
\description{
The default query of Ribosome Profiling human, will result in internal
entrez search of:
Ribosome[All Fields] AND Profiling[All Fields] AND ("Homo sapiens"[Organism]
OR human[All Fields])
}
\examples{
term <- "Ribosome Profiling Saccharomyces cerevisiae"
# get_bioproject_candidates(term)
}
\references{
https://www.ncbi.nlm.nih.gov/books/NBK25501/
}
\seealso{
Other sra: 
\code{\link{browseSRA}()},
\code{\link{download.SRA}()},
\code{\link{download.SRA.metadata}()},
\code{\link{download.ebi}()},
\code{\link{install.sratoolkit}()},
\code{\link{rename.SRA.files}()}
}
\concept{sra}
