% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coverage_heatmaps.R
\name{heatMap_single}
\alias{heatMap_single}
\title{Coverage heatmap of single libraries}
\usage{
heatMap_single(
  region,
  tx,
  reads,
  outdir,
  scores = "sum",
  upstream,
  downstream,
  zeroPosition = upstream,
  returnCoverage = FALSE,
  acceptedLengths = NULL,
  legendPos = "right",
  colors = "default",
  addFracPlot = TRUE,
  location = "start site",
  shifting = NULL,
  skip.last = FALSE,
  title = NULL,
  gradient.max = "default"
)
}
\arguments{
\item{region}{#' a \code{\link{GRangesList}} object of region,
usually either leaders, cds', 3' utrs or ORFs, start region, stop regions etc.
This is the region that will be mapped in heatmap}

\item{tx}{default NULL, a GRangesList of transcripts or (container region),
names of tx must contain all grl names. The names of grl can also be the
ORFik orf names. that is "txName_id"}

\item{reads}{a \code{\link{GAlignments}}, \code{\link{GRanges}}, or
precomputed coverage as \code{\link{covRleList}}
(where names of covRle objects are readlengths) of
RiboSeq, RnaSeq etc. \cr Weigths for scoring is default the 'score'
column in 'reads'. Can also be random access paths to bigWig or fstwig file.
Do not use random access for more than a few genes, then loading the entire files
is usually better.}

\item{outdir}{a character path to save file as: not just directory,
but full name.}

\item{scores}{character vector, default "sum",
either of zscore, transcriptNormalized, sum, mean, median, ..
see ?coverageScorings for info and more alternatives.}

\item{upstream}{an integer, relative region to get upstream from.}

\item{downstream}{an integer, relative region to get downstream from}

\item{zeroPosition}{an integer DEFAULT (upstream), what is the center point?
Like leaders and cds combination, then 0 is the TIS and -1 is last base in leader.
NOTE!: if windows have different widths, this will be ignored.}

\item{returnCoverage}{logical, default: FALSE, return coverage, if FALSE
returns plot instead.}

\item{acceptedLengths}{an integer vector (NULL), the read lengths accepted.
Default NULL, means all lengths accepted.}

\item{legendPos}{a character, Default "right". Where should the fill legend
be ? ("top", "bottom", "right", "left")}

\item{colors}{character vector, default: "default", this gives you:
c("white", "yellow2", "yellow3", "lightblue", "blue", "navy"),
do "high" for more high contrasts, or specify your own colors.}

\item{addFracPlot}{Add margin histogram plot on top of heatmap with
fractions per positions}

\item{location}{a character, default "start site", will make xlabel of heatmap be
Position relative to "start site" or alternative given.}

\item{shifting}{a character, default NULL (no shifting), can also be
either of c("5prime", "3prime")}

\item{skip.last}{skip top(highest) read length, default FALSE}

\item{title}{a character, default NULL (no title),
what is the top title of plot?}

\item{gradient.max}{numeric or character, default: "default", which is:
\code{max(coverage$score)}, the max coverage over all readlengths.
 If you want all plots to use same reference point
for max scaling, then first detect this point, look at max in plot etc,
and use that value, to get all plots to have same max point.}
}
\value{
ggplot2 grob (default), data.table (if returnCoverage is TRUE)
}
\description{
Coverage heatmap of single libraries
}
\seealso{
Other heatmaps: 
\code{\link{coverageHeatMap}()},
\code{\link{heatMapL}()},
\code{\link{heatMapRegion}()}
}
\concept{heatmaps}
