% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_imports.R
\name{readBam}
\alias{readBam}
\title{Custom bam reader}
\usage{
readBam(
  path,
  chrStyle = NULL,
  param = NULL,
  strandMode = 0,
  only_unique_mappers = FALSE
)
}
\arguments{
\item{path}{a character / data.table with path to .bam file. There
are 3 input file possibilities.
\itemize{
 \item{single end : a character path (length 1)}
 \item{paired end (1 file) : Either a character path (length of 2),
 where path[2] is "paired-end", or a data.table with 2 columns,
 forward = path & reverse = "paired-end"}
 \item{paired end (2 files) : Either a character path (length of 2),
 where path[2] is path to R2, or a data.table with 2 columns,
 forward = path to R1 & reverse = path to R2. (This one is not used often)}
}}

\item{chrStyle}{a GRanges object, TxDb, FaFile,
, a \code{\link{seqlevelsStyle}} or \code{\link{Seqinfo}}.
(Default: NULL) to get seqlevelsStyle from. In addition if it
is a Seqinfo object, seqinfo will be updated.
Example of seqlevelsStyle update:
Is chromosome 1 called chr1 or 1,
 is mitocondrial chromosome called MT or chrM etc.
Will use 1st seqlevel-style if more are present.
Like: c("NCBI", "UCSC") -> pick "NCBI"}

\item{param}{\code{NULL} or a \link[Rsamtools]{ScanBamParam} object.
    Like for \code{\link[Rsamtools]{scanBam}}, this influences what fields
    and which records are imported. However, note that the fields specified
    thru this \link[Rsamtools]{ScanBamParam} object will be loaded
    \emph{in addition} to any field required for generating the returned
    object (\link[GenomicAlignments]{GAlignments}, \link[GenomicAlignments]{GAlignmentPairs},
    or \link[GenomicAlignments]{GappedReads} object),
    but only the fields requested by the user will actually be kept as
    metadata columns of the object.

    By default (i.e. \code{param=NULL} or \code{param=ScanBamParam()}), no 
    additional field is loaded. The flag used is 
    \code{scanBamFlag(isUnmappedQuery=FALSE)} for
    \code{readGAlignments}, \code{readGAlignmentsList}, and
    \code{readGappedReads}.
    (i.e. only records corresponding to mapped reads are loaded),
    and \code{scanBamFlag(isUnmappedQuery=FALSE, isPaired=TRUE,
    hasUnmappedMate=FALSE)} for \code{readGAlignmentPairs}
    (i.e. only records corresponding to paired-end reads with both ends
    mapped are loaded).
  }

\item{strandMode}{numeric, default 0. Only used for paired end bam files.
One of (0: strand = *, 1: first read of pair is +, 2: first read of pair is -).
See ?strandMode. Note: Sets default to 0 instead of 1, as readGAlignmentPairs uses 1.
This is to guarantee hits, but will also make mismatches of overlapping
transcripts in opposite directions.}

\item{only_unique_mappers, }{logical, default FALSE. Only load unique mappers.
For bam files it extracts NH flag, for other formats, it presumes the presence of
a directory './unique_mappers' relative to bam file directory.}
}
\value{
a \code{\link{GAlignments}} or \code{\link{GAlignmentPairs}} object of bam file
}
\description{
Read in Bam file from either single end or paired end.
Safer combined version of \code{\link{readGAlignments}} and
readGAlignmentPairs that takes care of some common errors.\cr
If QNAMES of the aligned reads are from collapsed fasta files
(if the names are formated from collapsing in either
(ORFik, ribotoolkit or fastx)), the
bam file will contain a meta column called "score" with the counts
of duplicates per read. Only works for single end reads, as perfect duplication
events for paired end is more rare and therefor not supported!.\cr
}
\details{
In the future will use a faster .bam loader for big .bam files in R.
}
\examples{
bam_file <- system.file("extdata/Danio_rerio_sample", "ribo-seq.bam", package = "ORFik")
readBam(bam_file, "UCSC")
}
\seealso{
Other utils: 
\code{\link{bedToGR}()},
\code{\link{convertToOneBasedRanges}()},
\code{\link{export.bed12}()},
\code{\link{export.bigWig}()},
\code{\link{export.fstwig}()},
\code{\link{export.wiggle}()},
\code{\link{fimport}()},
\code{\link{findFa}()},
\code{\link{fread.bed}()},
\code{\link{optimizeReads}()},
\code{\link{readBigWig}()},
\code{\link{readWig}()}
}
\concept{utils}
