% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ranges_helpers.R
\name{reduceKeepAttr}
\alias{reduceKeepAttr}
\title{Reduce GRanges / GRangesList}
\usage{
reduceKeepAttr(
  grl,
  keep.names = FALSE,
  drop.empty.ranges = FALSE,
  min.gapwidth = 1L,
  with.revmap = FALSE,
  with.inframe.attrib = FALSE,
  ignore.strand = FALSE,
  min.strand.decreasing = TRUE
)
}
\arguments{
\item{grl}{a \code{\link{GRangesList}} or GRanges object}

\item{keep.names}{(FALSE) keep the names and meta columns of the GRangesList}

\item{drop.empty.ranges}{(FALSE) if a group is empty (width 0), delete it.}

\item{min.gapwidth}{(1L) how long gap can it be between two ranges,
to merge them.}

\item{with.revmap}{(FALSE) return info on which mapped to which}

\item{with.inframe.attrib}{(FALSE) For internal use.}

\item{ignore.strand}{(FALSE), can different strands be reduced together.}

\item{min.strand.decreasing}{(TRUE), if GRangesList, return minus strand group
ranges in decreasing order (1-5, 30-50) -> (30-50, 1-5)}
}
\value{
A reduced GRangesList
}
\description{
Reduce away all GRanges elements with 0-width.
}
\details{
Extends function \code{\link{reduce}}
by trying to keep names and meta columns, if it is a
GRangesList. It also does not lose sorting for GRangesList,
since original reduce sorts all by ascending position.
If keep.names == FALSE, it's just the normal GenomicRanges::reduce
with sorting negative strands descending for GRangesList.
}
\examples{
ORF <- GRanges(seqnames = "1",
               ranges = IRanges(start = c(1, 2, 3), end = c(1, 2, 3)),
               strand = "+")
# For GRanges
reduceKeepAttr(ORF, keep.names = TRUE)
# For GRangesList
grl <- GRangesList(tx1_1 = ORF)
reduceKeepAttr(grl, keep.names = TRUE)

}
\seealso{
Other ExtendGenomicRanges: 
\code{\link{asTX}()},
\code{\link{coveragePerTiling}()},
\code{\link{extendLeaders}()},
\code{\link{extendTrailers}()},
\code{\link{tile1}()},
\code{\link{txSeqsFromFa}()},
\code{\link{windowPerGroup}()}
}
\concept{ExtendGenomicRanges}
