% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/riboseq_features.R
\name{ribosomeReleaseScore}
\alias{ribosomeReleaseScore}
\title{Ribosome Release Score (RRS)}
\usage{
ribosomeReleaseScore(
  grl,
  RFP,
  GtfOrThreeUtrs,
  RNA = NULL,
  weight.RFP = 1L,
  weight.RNA = 1L,
  overlapGrl = NULL
)
}
\arguments{
\item{grl}{a \code{\link{GRangesList}} object
with usually either leaders, cds', 3' utrs or ORFs.}

\item{RFP}{RiboSeq reads as GAlignments, GRanges
or GRangesList object}

\item{GtfOrThreeUtrs}{if Gtf: a TxDb object of a gtf file transcripts is
called from: `threeUTRsByTranscript(Gtf, use.names = TRUE)`,
if object is GRangesList, it is presumed to be the 3' utrs}

\item{RNA}{RnaSeq reads as \code{\link{GAlignments}},
\code{\link{GRanges}} or GRangesList object}

\item{weight.RFP}{a vector (default: 1L). Can also be character name of
column in RFP. As in translationalEff(weight = "score") for:
GRanges("chr1", 1, "+", score = 5), would mean score column tells
that this alignment region was found 5 times.}

\item{weight.RNA}{Same as weightRFP but for RNA weights.
(default: 1L)}

\item{overlapGrl}{an integer, (default: NULL),
if defined must be countOverlaps(grl, RFP),
added for speed if you already have it}
}
\value{
a named vector of numeric values of scores, NA means that
no 3' utr was found for that transcript.
}
\description{
Ribosome Release Score is defined as
\preformatted{(RPFs over ORF)/(RPFs over 3' utrs)} and
additionaly normalized by lengths.
If RNA is added as argument, it will normalize by RNA counts
to justify location of 3' utrs.
It can be understood as a ribosome stalling feature.
A pseudo-count of one was added to both the ORF and downstream sums.
}
\examples{
ORF <- GRanges(seqnames = "1",
               ranges = IRanges(start = c(1, 10, 20), end = c(5, 15, 25)),
               strand = "+")
grl <- GRangesList(tx1_1 = ORF)
threeUTRs <- GRangesList(tx1 = GRanges("1", IRanges(40, 50), "+"))
RFP <- GRanges("1", IRanges(25, 25), "+")
RNA <- GRanges("1", IRanges(1, 50), "+")
ribosomeReleaseScore(grl, RFP, threeUTRs, RNA)

}
\references{
doi: 10.1016/j.cell.2013.06.009
}
\seealso{
Other features: 
\code{\link{computeFeatures}()},
\code{\link{computeFeaturesCage}()},
\code{\link{countOverlapsW}()},
\code{\link{disengagementScore}()},
\code{\link{distToCds}()},
\code{\link{distToTSS}()},
\code{\link{entropy}()},
\code{\link{floss}()},
\code{\link{fpkm}()},
\code{\link{fpkm_calc}()},
\code{\link{fractionLength}()},
\code{\link{initiationScore}()},
\code{\link{insideOutsideORF}()},
\code{\link{isInFrame}()},
\code{\link{isOverlapping}()},
\code{\link{kozakSequenceScore}()},
\code{\link{orfScore}()},
\code{\link{rankOrder}()},
\code{\link{ribosomeStallingScore}()},
\code{\link{startRegion}()},
\code{\link{startRegionCoverage}()},
\code{\link{stopRegion}()},
\code{\link{subsetCoverage}()},
\code{\link{translationalEff}()}
}
\concept{features}
