% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/riboseq_features.R
\name{ribosomeStallingScore}
\alias{ribosomeStallingScore}
\title{Ribosome Stalling Score (RSS)}
\usage{
ribosomeStallingScore(grl, RFP, weight = 1L, overlapGrl = NULL)
}
\arguments{
\item{grl}{a \code{\link{GRangesList}} object
with usually either leaders, cds', 3' utrs or ORFs.}

\item{RFP}{RiboSeq reads as GAlignments, GRanges
or GRangesList object}

\item{weight}{a numeric/integer vector or metacolumn name.
(default: 1L, no differential weighting).
If weight is name of defined meta column in reads object,
it gives the number of times a read was found at that position.
GRanges("chr1", 1, "+", score = 5), would mean "score" column tells
that this alignment region was found 5 times.
if 1L it means each read is weighted equal as 1,
this is what among others countOverlaps() presumes,
if single number (!= 1), it repeats for all ranges,
if vector with length > 1, it must be equal size of the
reads object.}

\item{overlapGrl}{an integer, (default: NULL),
if defined must be countOverlaps(grl, RFP),
added for speed if you already have it}
}
\value{
a named vector of numeric values of RSS scores
}
\description{
Is defined as \preformatted{(RPFs over ORF stop sites)/(RPFs over ORFs)}
and normalized by lengths
A pseudo-count of one was added to both the ORF and downstream sums.
}
\examples{
ORF <- GRanges(seqnames = "1",
               ranges = IRanges(start = c(1, 10, 20), end = c(5, 15, 25)),
               strand = "+")
grl <- GRangesList(tx1_1 = ORF)
RFP <- GRanges("1", IRanges(25, 25), "+")
ribosomeStallingScore(grl, RFP)

}
\references{
doi: 10.1016/j.cels.2017.08.004
}
\seealso{
Other features: 
\code{\link{computeFeatures}()},
\code{\link{computeFeaturesCage}()},
\code{\link{countOverlapsW}()},
\code{\link{disengagementScore}()},
\code{\link{distToCds}()},
\code{\link{distToTSS}()},
\code{\link{entropy}()},
\code{\link{floss}()},
\code{\link{fpkm}()},
\code{\link{fpkm_calc}()},
\code{\link{fractionLength}()},
\code{\link{initiationScore}()},
\code{\link{insideOutsideORF}()},
\code{\link{isInFrame}()},
\code{\link{isOverlapping}()},
\code{\link{kozakSequenceScore}()},
\code{\link{orfScore}()},
\code{\link{rankOrder}()},
\code{\link{ribosomeReleaseScore}()},
\code{\link{startRegion}()},
\code{\link{startRegionCoverage}()},
\code{\link{stopRegion}()},
\code{\link{subsetCoverage}()},
\code{\link{translationalEff}()}
}
\concept{features}
