% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uORF_helpers.R
\name{uORFSearchSpace}
\alias{uORFSearchSpace}
\title{Create search space to look for uORFs}
\usage{
uORFSearchSpace(
  fiveUTRs,
  cage = NULL,
  extension = 1000,
  filterValue = 1,
  restrictUpstreamToTx = FALSE,
  removeUnused = FALSE,
  cds = NULL
)
}
\arguments{
\item{fiveUTRs}{(GRangesList) The 5' leaders or full transcript sequences}

\item{cage}{Either a filePath for the CageSeq file as .bed .bam or .wig,
with possible compressions (".gzip", ".gz", ".bgz"), or already loaded
CageSeq peak data as GRanges or GAlignment.
NOTE: If it is a .bam file, it will add a score column by running:
convertToOneBasedRanges(cage, method = "5prime", addScoreColumn = TRUE)
The score column is then number of replicates of read, if score column is
something else, like read length, set the score column to NULL first.}

\item{extension}{The maximum number of basses upstream of the TSS to search
for CageSeq peak.}

\item{filterValue}{The minimum number of reads on cage position, for it to
be counted as possible new tss. (represented in score column in
CageSeq data) If you already filtered, set it to 0.}

\item{restrictUpstreamToTx}{a logical (FALSE). If TRUE: restrict leaders to
not extend closer than 5 bases from closest upstream leader, set this
to TRUE.}

\item{removeUnused}{logical (FALSE), if False:  (standard is to set them to
original annotation), If TRUE: remove leaders that did not have any cage
support.}

\item{cds}{(GRangesList) CDS of relative fiveUTRs, applicable only if you
want to extend 5' leaders downstream of CDS's, to allow upstream ORFs that
can overlap into CDS's.}
}
\value{
a GRangesList of newly assigned TSS for fiveUTRs,
 using CageSeq data.
}
\description{
Given a GRangesList of 5' UTRs or transcripts, reassign the start
sites using max peaks from CageSeq data (if CAGE is given).
A max peak is defined as new
TSS if it is within boundary of 5' leader range, specified by
`extension` in bp. A max peak must also be higher than minimum
CageSeq peak cutoff specified in `filterValue`. The new TSS will then
be the positioned where the cage read (with highest read count in the
interval). If you want to include uORFs going into the CDS, add this
argument too.
}
\examples{
# example 5' leader, notice exon_rank column
fiveUTRs <- GenomicRanges::GRangesList(
  GenomicRanges::GRanges(seqnames = "chr1",
                         ranges = IRanges::IRanges(1000, 2000),
                         strand = "+",
                         exon_rank = 1))
names(fiveUTRs) <- "tx1"

# make fake CageSeq data from promoter of 5' leaders, notice score column
cage <- GenomicRanges::GRanges(
  seqnames = "chr1",
  ranges =  IRanges::IRanges(500, 510),
  strand = "+",
  score = 10)

# finally reassign TSS for fiveUTRs
uORFSearchSpace(fiveUTRs, cage)

}
\seealso{
Other uorfs: 
\code{\link{addCdsOnLeaderEnds}()},
\code{\link{filterUORFs}()},
\code{\link{removeORFsWithSameStartAsCDS}()},
\code{\link{removeORFsWithSameStopAsCDS}()},
\code{\link{removeORFsWithStartInsideCDS}()},
\code{\link{removeORFsWithinCDS}()}
}
\concept{uorfs}
