% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addPlottingFactor.R
\name{addPlottingFactor}
\alias{addPlottingFactor}
\alias{addPlottingFactor,NanoStringGeoMxSet-method}
\alias{addPlottingFactor,matrix-method}
\alias{addPlottingFactor,tbl_df-method}
\alias{addPlottingFactor,tbl-method}
\alias{addPlottingFactor,data.frame-method}
\alias{addPlottingFactor,character-method}
\alias{addPlottingFactor,numeric-method}
\alias{addPlottingFactor,factor-method}
\title{Add plotting factor to \code{\link{SpatialOverlay}} object}
\usage{
addPlottingFactor(overlay, annots, plottingFactor, ...)

\S4method{addPlottingFactor}{NanoStringGeoMxSet}(overlay, annots, plottingFactor, countMatrix = "exprs")

\S4method{addPlottingFactor}{matrix}(overlay, annots, plottingFactor)

\S4method{addPlottingFactor}{tbl_df}(overlay, annots, plottingFactor)

\S4method{addPlottingFactor}{tbl}(overlay, annots, plottingFactor)

\S4method{addPlottingFactor}{data.frame}(overlay, annots, plottingFactor)

\S4method{addPlottingFactor}{character}(overlay, annots, plottingFactor)

\S4method{addPlottingFactor}{numeric}(overlay, annots, plottingFactor)

\S4method{addPlottingFactor}{factor}(overlay, annots, plottingFactor)
}
\arguments{
\item{overlay}{\code{\link{SpatialOverlay}} object}

\item{annots}{factor vector with the plottingFactor. if names match sample 
names in overlay vector will be matched on those, 
otherwise assumed in the correct order}

\item{plottingFactor}{name of the new plotting factor}

\item{...}{if using \code{NanoStringGeoMxSet}, name of count matrix to pull 
counts from}

\item{countMatrix}{name of count matrix to pull counts from}
}
\value{
\code{\link{SpatialOverlay}} object with new plotting factor
}
\description{
Add plotting factor to \code{\link{SpatialOverlay}} object
}
\examples{
muBrain <- readRDS(unzip(system.file("extdata", "muBrainSubset_SpatialOverlay.zip", 
                                    package = "SpatialOmicsOverlay")))

muBrainLW <- system.file("extdata", "muBrain_LabWorksheet.txt", 
                         package = "SpatialOmicsOverlay")

muBrainLW <- readLabWorksheet(muBrainLW, slideName = "D5761 (3)")

muBrain <- addPlottingFactor(overlay = muBrain, 
                             annots = muBrainLW, 
                             plottingFactor = "segment")

muBrainGxT <- readRDS(unzip(system.file("extdata", "muBrain_GxT.zip", 
                                  package = "SpatialOmicsOverlay")))

muBrain <- addPlottingFactor(overlay = muBrain, 
                             annots = muBrainGxT, 
                             plottingFactor = "Calm1",
                             countMatrix = "exprs")

muBrain <- addPlottingFactor(overlay = muBrain,
                             annots = seq_len(length(sampNames(muBrain))),
                             plottingFactor = "ROINum")

head(plotFactors(muBrain))

muBrain <- readRDS(unzip(system.file("extdata", "muBrainSubset_SpatialOverlay.zip", 
                                    package = "SpatialOmicsOverlay")))

muBrain <- addPlottingFactor(overlay = muBrain,
                             annots = as.factor(seq_len(length(sampNames(muBrain)))),
                             plottingFactor = "ROINum")

head(plotFactors(muBrain))
}
