% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bedbaser.R
\name{bb_save}
\alias{bb_save}
\title{Save a BED file or BEDset to a path given an id}
\usage{
bb_save(bedbase, bed_or_bedset_id, path, quietly = TRUE)
}
\arguments{
\item{bedbase}{BEDbase() object}

\item{bed_or_bedset_id}{integer(1) BED or BEDset record identifier}

\item{path}{character(1) directory to save file}

\item{quietly}{logical(1) (default \code{TRUE}) display messages}
}
\value{
An invisible \code{NULL}
}
\description{
Save a BED file or a BEDset to a local path. If the path does
not exist, \code{bb_save()} will abort.
}
\examples{
bedbase <- BEDbase()
ex_bed <- bb_example(bedbase, "bed")
bb_save(bedbase, ex_bed$id, tempdir())

}
