% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DA_Maaslin3.R
\name{DA_maaslin3}
\alias{DA_maaslin3}
\title{DA_maaslin3}
\usage{
DA_maaslin3(
  object,
  assay_name = "counts",
  formula = NULL,
  contrast = NULL,
  normalization = c("TSS", "CLR", "NONE"),
  transform = c("LOG", "PLOG", "NONE"),
  median_comparison_abundance = TRUE,
  small_random_effects = FALSE,
  stat_type = c("abundance", "prevalence"),
  pvalue_type = c("abundance", "prevalence", "joint"),
  correction = "BH",
  verbose = TRUE
)
}
\arguments{
\item{object}{a phyloseq or TreeSummarizedExperiment object.}

\item{assay_name}{the name of the assay to extract from the 
TreeSummarizedExperiment object (default \code{assayName = "counts"}). Not 
used if the input object is a phyloseq.}

\item{formula}{A formula in \code{lme4} format. Random effects,
    interactions, and functions of the metadata can be included (note that
    these functions will be applied after standardization if
    \code{standardize=TRUE}). Group, ordered, and strata variables can be
    specified as: \code{group(grouping_variable)},
    \code{ordered(ordered_variable)} and \code{strata(strata_variable)}. The
    other variable options below will not be considered if a formula is
    set.}

\item{contrast}{character vector with exactly, three elements: a string 
indicating the name of factor whose levels are the conditions to be 
compared, the name of the level of interest, and the name of the other 
level.}

\item{normalization}{The normalization to apply to the features before
    transformation and analysis. The option \code{TSS} (total sum scaling)
    is
    recommended, but \code{CLR} (centered log ratio) and \code{NONE} can
    also
    be used.}

\item{transform}{The transformation to apply to the features after
    normalization and before analysis. The option \code{LOG} (base 2) is
    recommended, but \code{PLOG} (pseudo-log) and \code{NONE} can also be
    used.}

\item{median_comparison_abundance}{Test abundance coefficients against a
    null value corresponding to the median coefficient for a metadata
    variable across the features. This is recommended for relative abundance
    data but should not be used for absolute abundance data.}

\item{small_random_effects}{Automatically replace random effects with 
    fixed effects in the logistic prevalence model to handle low numbers
    of observations per group.}

\item{stat_type}{Whether to return statistics based on abundance 
("abundance") or prevalence ("prevalence") models.}

\item{pvalue_type}{Whether to return p-values based on abundance 
("abundance") models, prevalence ("prevalence") models, or joint 
("joint") p-values. Choose "abundance" or "joint" when \code{stat_type} is
set to "abundance", choose "prevalence" when \code{stat_type} is set to
"prevalence".}

\item{correction}{The correction to obtain FDR-corrected q-values from
    raw
    p-values. Any valid options for \code{p.adjust} can be used.}

\item{verbose}{an optional logical value. If \code{TRUE}, information about
the steps of the algorithm is printed. Default \code{verbose = TRUE}.}
}
\value{
A list object containing the matrix of p-values `pValMat`,
a matrix of summary statistics for each tag `statInfo`, and a suggested 
`name` of the final object considering the parameters passed to the 
function.
}
\description{
Fast run for maaslin3 differential abundance detection method.
}
\details{
Some maaslin3 parameters are not available for customization in this 
implementation. For this reason they assume default values or are internally
assigned. The latter case is represented by:
\itemize{
\item \code{warn_prevalence} which is internally set to \code{TRUE} when 
\code{normalization = "TSS"} and \code{transform = "LOG"};
\item \code{subtract_median} which is internally set to the same 
\code{median_comparison_abundance} value;
\item \code{zero_threshold} which is automatically set to -1 when 
\code{transform = "PLOG"};
\item \code{evaluate_only} is automatically set to \code{"abundance"} when
\code{transform = "PLOG"}.
}

MaAsLin 3 produces both abundance and prevalence associations with 
individual p and adjusted p-values (specific to abundance or prevalence) as 
well as joint p and adjusted p-values for testing whether a metadatum is 
associated with either the abundance or prevalence. To avoid issues with 
having twice as many associations as other tools (from both abundance and 
prevalence), \code{stat_type} can be set to report the desired abundance or 
prevalence associations. When the abundance and prevalence associations are 
expected to go in the same direction, \code{pvalue_type = "joint"} allows to
return p-values and adjusted p-values taken from the joint p-values and 
adjusted p-values. 
Please refer to maaslin3's guide to choose proper parameter combinations.
}
\examples{
set.seed(1)
# Create a very simple phyloseq object
counts <- matrix(rnbinom(n = 60, size = 3, prob = 0.5), nrow = 10, ncol = 6)
metadata <- data.frame("Sample" = c("S1", "S2", "S3", "S4", "S5", "S6"),
                       "group" = as.factor(c("A", "A", "A", "B", "B", "B")))
ps <- phyloseq::phyloseq(phyloseq::otu_table(counts, taxa_are_rows = TRUE),
                         phyloseq::sample_data(metadata))
# Differential abundance
DA_maaslin3(object = ps, formula = "~ group", normalization = "CLR", 
    transform = "NONE", correction = "BH", contrast = c("group", "B", "A"), 
    verbose = FALSE, stat_type = "abundance", pvalue_type = "joint")
}
\seealso{
\code{\link[maaslin3]{maaslin3}}.
}
