% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DA_mixMC.R
\name{DA_mixMC}
\alias{DA_mixMC}
\title{DA_mixMC}
\usage{
DA_mixMC(
  object,
  pseudo_count = 1,
  assay_name = "counts",
  contrast = NULL,
  ID_variable = NULL,
  verbose = TRUE
)
}
\arguments{
\item{object}{a phyloseq or TreeSummarizedExperiment object.}

\item{pseudo_count}{a positive numeric value for the pseudo-count to be 
added. Default is 1.}

\item{assay_name}{the name of the assay to extract from the 
TreeSummarizedExperiment object (default \code{assayName = "counts"}). Not 
used if the input object is a phyloseq.}

\item{contrast}{character vector with exactly, three elements: a string 
indicating the name of factor whose levels are the conditions to be 
compared, the name of the level of interest, and the name of the other 
level.}

\item{ID_variable}{a character string indicating the name of the variable 
name corresponding to the repeated measures units (e.g., the subject ID).}

\item{verbose}{an optional logical value. If \code{TRUE}, information about
the steps of the algorithm is printed. Default \code{verbose = TRUE}.}
}
\value{
A list object containing the matrix of p-values `pValMat`,
a matrix of summary statistics for each tag `statInfo`, and a suggested 
`name` of the final object considering the parameters passed to the 
function. mixMC does not produce p-values. The frequency and the importance
values are produced instead. The frequency indicates the stability of 
the features across the folds of the cross validation. The importance 
indicates the magnitude of the discrimination for the features and their 
direction. Hence, `pValMat` matrix is filled with \code{1 - frequency} values 
which are not p-values. To find discriminant features a threshold on this 
statistic can be used (liberal < 1, < 0.5, < 0.1 conservative).
}
\description{
Fast run for mixMC sPLS-DA method for biomarker identification. It performs
a CLR transformation on the `counts + pseudo_counts` values. Then the 
sPLS-DA is tuned through a leave-one-out cross validation procedure.
}
\examples{
set.seed(1)
# Create a very simple phyloseq object
counts <- matrix(rnbinom(n = 60, size = 3, prob = 0.5), nrow = 10, ncol = 6)
metadata <- data.frame("Sample" = c("S1", "S2", "S3", "S4", "S5", "S6"),
                       "group" = as.factor(c("A", "A", "A", "B", "B", "B")))
ps <- phyloseq::phyloseq(phyloseq::otu_table(counts, taxa_are_rows = TRUE),
                         phyloseq::sample_data(metadata))
# Differential abundance
DA_mixMC(object = ps, pseudo_count = 1, contrast = c("group", "B", "A"),
    verbose = FALSE)
}
\seealso{
\code{\link[mixOmics]{splsda}}, \code{\link[mixOmics]{perf}}, 
\code{\link[mixOmics]{tune.splsda}}.
}
