% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichment.R
\name{enrichmentTest}
\alias{enrichmentTest}
\title{enrichmentTest}
\usage{
enrichmentTest(method, enrichmentCol, alternative = "greater")
}
\arguments{
\item{method}{Output of differential abundance detection method in which
DA information is extracted by the \code{getDA} function and the information
related to enrichment is appropriately added through the \code{addKnowledge}.}

\item{enrichmentCol}{name of the column containing information for enrichment
analysis.}

\item{alternative}{indicates the alternative hypothesis and must be
    one of \code{"two.sided"}, \code{"greater"} or \code{"less"}.
    You can specify just the initial letter.  Only used in the
    \eqn{2 \times 2}{2 by 2} case.}
}
\value{
a list of objects:
\describe{
    \item{\code{data}}{ a \code{data.frame} object with DA directions,
    statistics, and feature names;}
    \item{\code{tables}}{ a list of 2x2 contingency tables;}
    \item{\code{tests}}{ the list of Fisher exact tests' p-values for each
    contingency table;}
    \item{\code{summaries}}{ a list with the first element of each
    contingency table and its p-value (for graphical purposes);}}
}
\description{
Perform the Fisher exact test for all the possible 2x2 contingency tables,
considering differential abundance direction and enrichment variable.
}
\examples{
data("ps_plaque_16S")
data("microbial_metabolism")

# Extract genera from the phyloseq tax_table slot
genera <- phyloseq::tax_table(ps_plaque_16S)[, "GENUS"]
# Genera as rownames of microbial_metabolism data.frame
rownames(microbial_metabolism) <- microbial_metabolism$Genus
# Match OTUs to their metabolism
priorInfo <- data.frame(genera,
    "Type" =  microbial_metabolism[genera, "Type"])
# Unmatched genera becomes "Unknown"
unknown_metabolism <- is.na(priorInfo$Type)
priorInfo[unknown_metabolism, "Type"] <- "Unknown"
priorInfo$Type <- factor(priorInfo$Type)
# Add a more informative names column
priorInfo[, "newNames"] <- paste0(rownames(priorInfo), priorInfo[, "GENUS"])

# DA Analysis

# Make sure the subject ID variable is a factor
phyloseq::sample_data(ps_plaque_16S)[, "RSID"] <- as.factor(
    phyloseq::sample_data(ps_plaque_16S)[["RSID"]])
    
# Add scaling factors
ps_plaque_16S <- norm_edgeR(object = ps_plaque_16S, method = "TMM")

# DA analysis
da.limma <- DA_limma(
    object = ps_plaque_16S,
    design = ~ 1 + RSID + HMP_BODY_SUBSITE,
    coef = "HMP_BODY_SUBSITESupragingival Plaque",
    norm = "TMM"
)

DA <- getDA(method = da.limma, slot = "pValMat", colName = "adjP",
    type = "pvalue", direction = "logFC", threshold_pvalue = 0.05,
    threshold_logfc = 1, top = NULL)
    
# Add a priori information
DA_info <- addKnowledge(method = DA, priorKnowledge = priorInfo,
    enrichmentCol = "Type", namesCol = "newNames")
    
# Create contingency tables and compute F tests
DA_info_enriched <- enrichmentTest(method = DA_info, enrichmentCol = "Type",
    alternative = "greater")
}
\seealso{
\code{\link{extractDA}}, \code{\link{addKnowledge}}, and
\code{\link{createEnrichment}}
}
