% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{extractStatistics}
\alias{extractStatistics}
\title{extractStatistics}
\usage{
extractStatistics(
  object,
  slot = "pValMat",
  colName = "rawP",
  type = "pvalue",
  direction = NULL,
  verbose = FALSE
)
}
\arguments{
\item{object}{Output of differential abundance detection methods.
\code{pValMat}, \code{statInfo} matrices, and method's \code{name} must be
present (See vignette for detailed information).}

\item{slot}{A character vector with 1 or number-of-methods-times repeats of
the slot names where to extract values for each method
(default \code{slot = "pValMat"}).}

\item{colName}{A character vector with 1 or number-of-methods-times repeats
of the column name of the slot where to extract values for each method
(default \code{colName = "rawP"}).}

\item{type}{A character vector with 1 or number-of-methods-times repeats
of the value type of the column selected where to extract values for each
method. Two values are possible: \code{"pvalue"} or \code{"logfc"}
(default \code{type = "pvalue"}).}

\item{direction}{A character vector with 1 or number-of-methods-times repeats
of the \code{statInfo}'s column name containing information about the signs
of differential abundance (usually log fold changes) for each method
(default \code{direction = NULL}).}

\item{verbose}{Boolean to display the kind of extracted values
(default \code{verbose = FALSE}).}
}
\value{
A vector or a \code{data.frame} for each method. If
\code{direction = NULL}, the \code{colname} column values, transformed
according to \code{type} (not tranformed if \code{type = "pvalue"},
\code{-abs(value)} if \code{type = "logfc"}), of the \code{slot} are reported
, otherwise the \code{direction} column of the \code{statInfo} matrix is
added to the output.
}
\description{
Extract the list of p-values or/and log fold changes from the outputs of the
differential abundance detection methods.
}
\examples{
data("ps_plaque_16S")
# Add scaling factors
my_norm <- setNormalizations(fun = c("norm_edgeR", "norm_CSS"),
    method = c("TMM", "CSS"))
ps_plaque_16S <- runNormalizations(normalization_list = my_norm,
    object = ps_plaque_16S)
# Perform DA analysis
my_methods <- set_limma(design = ~ 1 + HMP_BODY_SUBSITE, coef = 2,
    norm = c("TMM", "CSS"))
Plaque_16S_DA <- runDA(method_list = my_methods, object = ps_plaque_16S)
### Extract statistics for concordance analysis:
# Only p-values
extracted_pvalues <- extractStatistics(
    object = Plaque_16S_DA, slot =
        "pValMat", colName = "rawP", type = "pvalue"
)
# Only transformed log fold changes -abs(logFC)
extracted_abslfc <- extractStatistics(
    object = Plaque_16S_DA, slot =
        "statInfo", colName = "logFC", type = "logfc"
)
# Only transformed log fold changes for a method and p-values for the other
extracted_abslfc_pvalues <- extractStatistics(
    object = Plaque_16S_DA,
    slot = c("statInfo", "pValMat"), colName = c("logFC", "rawP"), type =
        c("logfc", "pvalue")
)
### Extract statistics for enrichment analysis:
# p-values and log fold changes
extracted_pvalues_and_lfc <- extractStatistics(
    object = Plaque_16S_DA,
    slot = "pValMat", colName = "rawP", type = "pvalue", direction = "logFC"
)
# transformed log fold changes and untouched log fold changes
extracted_abslfc_and_lfc <- extractStatistics(
    object = Plaque_16S_DA,
    slot = "statInfo", colName = "logFC", type = "logfc", direction =
        "logFC"
)
# Only transformed log fold changes for a method and p-values for the other
extracted_mix <- extractStatistics(
    object = Plaque_16S_DA,
    slot = c("statInfo", "pValMat"), colName = c("logFC", "rawP"), type =
        c("logfc", "pvalue"), direction = "logFC"
)
}
\seealso{
\code{\link{getStatistics}}
}
