% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{getDA}
\alias{getDA}
\title{getDA}
\usage{
getDA(
  method,
  slot = "pValMat",
  colName = "rawP",
  type = "pvalue",
  direction = NULL,
  threshold_pvalue = 1,
  threshold_logfc = 0,
  top = NULL,
  verbose = FALSE
)
}
\arguments{
\item{method}{Output of a differential abundance detection method.
\code{pValMat}, \code{statInfo} matrices, and method's \code{name} must be
present (See vignette for detailed information).}

\item{slot}{The slot name where to extract values
(default \code{slot = "pValMat"}).}

\item{colName}{The column name of the slot where to extract values
(default \code{colName = "rawP"}).}

\item{type}{The value type of the column selected where to extract values.
Two values are possible: \code{"pvalue"} or \code{"logfc"}
(default \code{type = "pvalue"}).}

\item{direction}{\code{statInfo}'s column name containing information about
the signs of differential abundance (usually log fold changes)
(default \code{direction = NULL}).}

\item{threshold_pvalue}{Threshold value for p-values. If present, features
with p-values lower than \code{threshold_pvalue} are considered
differentially abundant. Set \code{threshold_pvalue = 1} to not filter by
p-values.}

\item{threshold_logfc}{Threshold value for log fold changes. If present,
features with log fold change absolute values higher than
\code{threshold_logfc} are considered differentially abundant. Set
\code{threshold_logfc = 0} to not filter by log fold change values.}

\item{top}{If not null, the \code{top} number of features, ordered by
p-values or log fold change values, are considered as differentially
abundant (default \code{top = NULL}).}

\item{verbose}{Boolean to display the kind of extracted values
(default \code{verbose = FALSE}).}
}
\value{
A \code{data.frame} with several columns:
\describe{
    \item{\code{stat}}{ which contains the p-values or the absolute log fold
    change values;}
    \item{\code{direction}}{ which is present if \code{method} was a
    \code{data.frame} object, it contains the information about
    directionality of differential abundance (usually log fold changes);}
    \item{\code{DA}}{ which can contain several values according to
    thresholds and inputs. \code{"DA"} or \code{"non-DA"} if \code{method}
    object was a vector, \code{"UP Abundant"}, \code{"DOWN Abundant"}, or
    \code{"non-DA"} if \code{method} was a \code{data.frame}.}}
}
\description{
Inspect the list of p-values or/and log fold changes from the output of a
differential abundance detection method.
}
\examples{
data("ps_plaque_16S")
# Add scaling factors
ps_plaque_16S <- norm_edgeR(object = ps_plaque_16S, method = "TMM")
# DA analysis
da.limma <- DA_limma(
    object = ps_plaque_16S,
    design = ~ 1 + HMP_BODY_SUBSITE,
    coef = 2,
    norm = "TMM"
)
# features with p-value < 0.1 as DA
getDA(
    method = da.limma, slot = "pValMat", colName = "rawP", type = "pvalue",
    direction = NULL, threshold_pvalue = 0.1, threshold_logfc = 0,
    top = NULL
)
# top 10 feature with highest logFC are DA
getDA(
    method = da.limma, slot = "pValMat", colName = "rawP", type = "pvalue",
    direction = "logFC", threshold_pvalue = 1, threshold_logfc = 0, top = 10
)
# features with p-value < 0.1 and |logFC| > 1 are DA
getDA(
    method = da.limma, slot = "pValMat", colName = "rawP", type = "pvalue",
    direction = "logFC", threshold_pvalue = 0.1, threshold_logfc = 1, top =
        NULL
)
# top 10 features with |logFC| > 1 are DA
getDA(
    method = da.limma, slot = "pValMat", colName = "rawP", type = "pvalue",
    direction = "logFC", threshold_pvalue = 1, threshold_logfc = 1, top = 10
)
}
\seealso{
\code{\link{getStatistics}}, \code{\link{extractDA}}
}
