% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{getStatistics}
\alias{getStatistics}
\title{getStatistics}
\usage{
getStatistics(
  method,
  slot = "pValMat",
  colName = "rawP",
  type = "pvalue",
  direction = NULL,
  verbose = FALSE
)
}
\arguments{
\item{method}{Output of a differential abundance detection method.
\code{pValMat}, \code{statInfo} matrices, and method's \code{name} must be
present (See vignette for detailed information).}

\item{slot}{The slot name where to extract values
(default \code{slot = "pValMat"}).}

\item{colName}{The column name of the slot where to extract values
(default \code{colName = "rawP"}).}

\item{type}{The value type of the column selected where to extract values.
Two values are possible: \code{"pvalue"} or \code{"logfc"}
(default \code{type = "pvalue"}).}

\item{direction}{\code{statInfo}'s column name containing information about
the signs of differential abundance (usually log fold changes)
(default \code{direction = NULL}).}

\item{verbose}{Boolean to display the kind of extracted values
(default \code{verbose = FALSE}).}
}
\value{
A vector or a \code{data.frame}. If \code{direction = NULL},
the \code{colname} column values, transformed according to \code{type} (not
tranformed if \code{type = "pvalue"}, \code{-abs(value)} if
\code{type = "logfc"}), of the \code{slot} are reported, otherwise the
\code{direction} column of the \code{statInfo} matrix is added to the output.
}
\description{
Extract the list of p-values or/and log fold changes from the output of a
differential abundance detection method.
}
\examples{
data("ps_plaque_16S")
# Add scaling factors
ps_plaque_16S <- norm_edgeR(object = ps_plaque_16S, method = "TMM")
# DA analysis
da.limma <- DA_limma(
    object = ps_plaque_16S,
    design = ~ 1 + HMP_BODY_SUBSITE,
    coef = 2,
    norm = "TMM"
)
# get p-values
getStatistics(
    method = da.limma, slot = "pValMat", colName = "rawP",
    type = "pvalue", direction = NULL
)
# get negative abs(logFC) values
getStatistics(
    method = da.limma, slot = "statInfo", colName = "logFC",
    type = "logfc", direction = NULL
)
# get p-values and logFC
getStatistics(
    method = da.limma, slot = "pValMat", colName = "rawP",
    type = "pvalue", direction = "logFC"
)
}
\seealso{
\code{\link{extractStatistics}}
}
