% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotEnrichment.R
\name{plotPositives}
\alias{plotPositives}
\title{plotPositives}
\usage{
plotPositives(positives, cols = NULL)
}
\arguments{
\item{positives}{\code{data.frame} object produced by
\code{createPositives()} function.}

\item{cols}{named vector of cols (default \code{cols = NULL}).}
}
\value{
a \code{ggplot2} object.
}
\description{
Plot the difference between the number of true positives (TP)
and false positives (FP) for each method and for each 'top' threshold
provided by the \code{createPositives()} function.
}
\examples{
data("ps_plaque_16S")
data("microbial_metabolism")

# Extract genera from the phyloseq tax_table slot
genera <- phyloseq::tax_table(ps_plaque_16S)[, "GENUS"]
# Genera as rownames of microbial_metabolism data.frame
rownames(microbial_metabolism) <- microbial_metabolism$Genus
# Match OTUs to their metabolism
priorInfo <- data.frame(genera,
    "Type" =  microbial_metabolism[genera, "Type"])
# Unmatched genera becomes "Unknown"
unknown_metabolism <- is.na(priorInfo$Type)
priorInfo[unknown_metabolism, "Type"] <- "Unknown"
priorInfo$Type <- factor(priorInfo$Type)
# Add a more informative names column
priorInfo[, "newNames"] <- paste0(rownames(priorInfo), priorInfo[, "GENUS"])

# Add some normalization/scaling factors to the phyloseq object
my_norm <- setNormalizations(fun = c("norm_edgeR", "norm_CSS"),
    method = c("TMM", "CSS"))
ps_plaque_16S <- runNormalizations(normalization_list = my_norm,
    object = ps_plaque_16S)
# Initialize some limma based methods
my_limma <- set_limma(design = ~ 1 + RSID + HMP_BODY_SUBSITE, 
    coef = "HMP_BODY_SUBSITESupragingival Plaque",
    norm = c("TMM", "CSS"))

# Make sure the subject ID variable is a factor
phyloseq::sample_data(ps_plaque_16S)[, "RSID"] <- as.factor(
    phyloseq::sample_data(ps_plaque_16S)[["RSID"]])
    
# Perform DA analysis
Plaque_16S_DA <- runDA(method_list = my_limma, object = ps_plaque_16S)

# Count TPs and FPs, from the top 1 to the top 20 features.
# As direction is supplied, features are ordered by "logFC" absolute values.
positives <- createPositives(object = Plaque_16S_DA,
    priorKnowledge = priorInfo, enrichmentCol = "Type", 
    namesCol = "newNames", slot = "pValMat", colName = "rawP", 
    type = "pvalue", direction = "logFC", threshold_pvalue = 1, 
    threshold_logfc = 0, top = 1:20, alternative = "greater", 
    verbose = FALSE,
    TP = list(c("DOWN Abundant", "Anaerobic"), c("UP Abundant", "Aerobic")),
    FP = list(c("DOWN Abundant", "Aerobic"), c("UP Abundant", "Anaerobic")))

# Plot the TP-FP differences for each threshold
plotPositives(positives = positives)
}
\seealso{
\code{\link{getPositives}}, \code{\link{createPositives}}.
}
