% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/concordance.R
\name{runSplits}
\alias{runSplits}
\title{runSplits}
\usage{
runSplits(
  split_list,
  method_list,
  normalization_list,
  object,
  assay_name = "counts",
  min_counts = 0,
  min_samples = 0,
  verbose = TRUE,
  BPPARAM = BiocParallel::SerialParam()
)
}
\arguments{
\item{split_list}{A list of 2 \code{data.frame} objects: \code{Subset1} and
\code{Subset2} produced by the \code{\link{createSplits}} function.}

\item{method_list}{a list object containing the methods and their parameters.}

\item{normalization_list}{a list object containing the normalization method
names and their parameters produced by \code{\link{setNormalizations}}.}

\item{object}{a phyloseq object.}

\item{assay_name}{the name of the assay to extract from the 
TreeSummarizedExperiment object (default \code{assayName = "counts"}). Not 
used if the input object is a phyloseq.}

\item{min_counts}{Parameter to filter taxa. Set this number to keep features 
with more than \code{min_counts} counts in more than \code{min_samples} 
samples (default \code{min_counts = 0}).}

\item{min_samples}{Parameter to filter taxa. Set this number to keep 
features with a \code{min_counts} counts in more than \code{min_samples} 
samples (default \code{min_samples = 0}).}

\item{verbose}{an optional logical value. If \code{TRUE}, information about
the steps of the algorithm is printed. Default \code{verbose = TRUE}.}

\item{BPPARAM}{An optional \code{\link[BiocParallel]{BiocParallelParam}} instance
    defining the parallel back-end to be used during evaluation.
  }
}
\value{
A named list containing the results for each method.
}
\description{
Run the differential abundance detection methods on split datasets.
}
\examples{
data(ps_plaque_16S)

# Balanced design
my_splits <- createSplits(
    object = ps_plaque_16S, varName = "HMP_BODY_SUBSITE", balanced = TRUE,
    paired = "RSID", N = 10 # N = 100 suggested
)

# Make sure the subject ID variable is a factor
phyloseq::sample_data(ps_plaque_16S)[, "RSID"] <- as.factor(
    phyloseq::sample_data(ps_plaque_16S)[["RSID"]])

# Initialize some limma based methods
my_limma <- set_limma(design = ~ RSID + HMP_BODY_SUBSITE, 
    coef = "HMP_BODY_SUBSITESupragingival Plaque",
    norm = c("TMM", "CSS"))

# Set the normalization methods according to the DA methods
my_norm <- setNormalizations(fun = c("norm_edgeR", "norm_CSS"),
    method = c("TMM", "CSS"))

# Run methods on split datasets
results <- runSplits(split_list = my_splits, method_list = my_limma,
    normalization_list = my_norm, object = ps_plaque_16S)
}
