% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DA_MAST.R
\name{set_MAST}
\alias{set_MAST}
\title{set_MAST}
\usage{
set_MAST(
  assay_name = "counts",
  pseudo_count = FALSE,
  rescale = c("median", "default"),
  design = NULL,
  coefficient = NULL,
  expand = TRUE
)
}
\arguments{
\item{assay_name}{the name of the assay to extract from the 
TreeSummarizedExperiment object (default \code{assayName = "counts"}). Not 
used if the input object is a phyloseq.}

\item{pseudo_count}{add 1 to all counts if TRUE (default
\code{pseudo_count = FALSE}).}

\item{rescale}{Rescale count data, per million if 'default', or per median
library size if 'median' ('median' is suggested for metagenomics data).}

\item{design}{The model for the count distribution. Can be the variable name,
or a character similar to "~ 1 + group", or a formula, or a `model.matrix`
object.}

\item{coefficient}{The coefficient of interest as a single word formed by 
the variable name and the non reference level. (e.g.: 'ConditionDisease' if 
the reference level for the variable 'Condition' is 'control').}

\item{expand}{logical, if TRUE create all combinations of input parameters
(default \code{expand = TRUE})}
}
\value{
A named list containing the set of parameters for \code{DA_MAST}
method.
}
\description{
Set the parameters for MAST differential abundance detection method.
}
\examples{
# Set some basic combinations of parameters for MAST
base_MAST <- set_MAST(design = ~ group, coefficient = "groupB")
# Set many possible combinations of parameters for MAST
all_MAST <- set_MAST(pseudo_count = c(TRUE, FALSE), rescale = c("median",
    "default"), design = ~ group, coefficient = "groupB")
}
\seealso{
\code{\link{DA_MAST}}
}
