% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DA_Maaslin2.R
\name{set_Maaslin2}
\alias{set_Maaslin2}
\title{set_Maaslin2}
\usage{
set_Maaslin2(
  assay_name = "counts",
  normalization = c("TSS", "CLR", "CSS", "NONE", "TMM"),
  transform = c("LOG", "LOGIT", "AST", "NONE"),
  analysis_method = c("LM", "CPLM", "ZICP", "NEGBIN", "ZINB"),
  correction = "BH",
  random_effects = NULL,
  fixed_effects = NULL,
  contrast = NULL,
  reference = NULL,
  expand = TRUE
)
}
\arguments{
\item{assay_name}{the name of the assay to extract from the 
TreeSummarizedExperiment object (default \code{assayName = "counts"}). Not 
used if the input object is a phyloseq.}

\item{normalization}{
    The normalization method to apply.
}

\item{transform}{
    The transform to apply.
}

\item{analysis_method}{
    The analysis method to apply.
}

\item{correction}{
    The correction method for computing the q-value.
}

\item{random_effects}{
    The random effects for the model, comma-delimited for multiple effects.
}

\item{fixed_effects}{
    The fixed effects for the model, comma-delimited for multiple effects.
}

\item{contrast}{character vector with exactly, three elements: a string 
indicating the name of factor whose levels are the conditions to be 
compared, the name of the level of interest, and the name of the other 
level.}

\item{reference}{
    The factor to use as a reference for a variable with more than two levels
    provided as a string of 'variable,reference'
    semi-colon delimited for multiple variables.
}

\item{expand}{logical, if TRUE create all combinations of input parameters
(default \code{expand = TRUE}).}
}
\value{
A named list containing the set of parameters for \code{DA_Maaslin2}
method.
}
\description{
Set the parameters for Maaslin2 differential abundance detection method.
}
\examples{
# Set some basic combinations of parameters for Maaslin2
base_Maaslin2 <- set_Maaslin2(normalization = "TSS", transform = "LOG",
    analysis_method = "LM", fixed_effects = "group",
    contrast = c("group", "B", "A"))
many_Maaslin2 <- set_Maaslin2(normalization = c("TSS", "CLR", "CSS", "TMM", 
    "NONE"), transform = c("LOG", "NONE"),
    analysis_method = c("LM", "NEGBIN"), fixed_effects = "group",
    contrast = c("group", "B", "A"))
}
\seealso{
\code{\link{DA_Maaslin2}}
}
