% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DA_Seurat.R
\name{set_Seurat}
\alias{set_Seurat}
\title{set_Seurat}
\usage{
set_Seurat(
  assay_name = "counts",
  pseudo_count = FALSE,
  test = "wilcox",
  contrast = NULL,
  norm = "LogNormalize",
  scale.factor = 10000,
  expand = TRUE
)
}
\arguments{
\item{assay_name}{the name of the assay to extract from the 
TreeSummarizedExperiment object (default \code{assayName = "counts"}). Not 
used if the input object is a phyloseq.}

\item{pseudo_count}{add 1 to all counts if TRUE (default
\code{pseudo_count = FALSE}).}

\item{test}{Denotes which test to use. Available options are:
\describe{\item{\code{"wilcox"}}{ Identifies differentially abundant 
features between two groups of samples using a Wilcoxon Rank Sum test 
(default).}
\item{\code{"bimod"}}{ Likelihood-ratio test for the feature abundances, 
(McDavid et al., Bioinformatics, 2013).}
\item{\code{"roc"}}{ Identifies 'markers' of feature abundance using ROC 
analysis. For each feature, evaluates (using AUC) a classifier built on that 
feature alone, to classify between two groups of cells. An AUC value of 1 
means that abundance values for this feature alone can perfectly classify the
two groupings (i.e. Each of the samples in group.1 exhibit a higher level 
than each of the samples in group.2). An AUC value of 0 also means there is 
perfect classification, but in the other direction. A value of 0.5 implies 
that the feature has no predictive power to classify the two groups. Returns 
a 'predictive power' (abs(AUC-0.5) * 2) ranked matrix of putative 
differentially expressed genes.}
\item{\code{"t"}}{ Identify differentially abundant features between two 
groups of samples using the Student's t-test.}
\item{\code{"negbinom"}}{ Identifies differentially abundant features 
between two groups of samples using a negative binomial generalized linear 
model.}
\item{\code{"poisson"}}{ Identifies differentially abundant features between 
two groups of samples using a poisson generalized linear model.}
\item{\code{"LR"}}{ Uses a logistic regression framework to determine 
differentially abundant features. Constructs a logistic regression model 
predicting group membership based on each feature individually and compares 
this to a null model with a likelihood ratio test.}
\item{\code{"MAST"}}{ Identifies differentially expressed genes between two 
groups of cells using a hurdle model tailored to scRNA-seq data. Utilizes 
the MAST package to run the DE testing.}
\item{\code{"DESeq2"}}{ Identifies differentially abundant features between 
two groups of samples based on a model using DESeq2 which uses a negative 
binomial distribution (Love et al, Genome Biology, 2014).}}}

\item{contrast}{character vector with exactly three elements: the name of a
factor in the design formula, the name of the numerator level for the fold
change, and the name of the denominator level for the fold change.}

\item{norm}{Method for normalization. 
\describe{\item{\code{LogNormalize}}{ Feature counts for each sample are 
divided by the total counts of that sample and multiplied by the 
scale.factor. This is then natural-log transformed using log1p;}
\item{\code{CLR}}{ Applies a centered log ratio transformation;}
\item{\code{RC}}{ Relative counts. Feature counts for each sample are 
divided by the total counts of that sample and multiplied by the 
scale.factor. No log-transformation is applied. For counts per million 
(CPM) set scale.factor = 1e6;}
\item{\code{none}}{ No normalization}}}

\item{scale.factor}{Sets the scale factor for cell-level normalization}

\item{expand}{logical, if TRUE create all combinations of input parameters
(default \code{expand = TRUE})}
}
\value{
A named list containing the set of parameters for \code{DA_Seurat}
method.
}
\description{
Set the parameters for Seurat differential abundance detection method.
}
\examples{
# Set some basic combinations of parameters for Seurat
base_Seurat <- set_Seurat(contrast = c("group", "B", "A"))
# Set many possible combinations of parameters for Seurat
all_Seurat <- set_Seurat(test = c("wilcox", "t", "negbinom", "poisson"),
    norm = c("LogNormalize", "CLR", "RC", "none"), 
    scale.factor = c(1000, 10000), contrast = c("group", "B", "A"))
}
\seealso{
\code{\link{DA_Seurat}}
}
