% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/methods.R
\docType{methods}
\name{betaHMM}
\alias{betaHMM}
\alias{betaHMM,matrix,matrix-method}
\alias{betaHMM-methods}
\alias{betaHMM,data.frame,data.frame-method}
\alias{betaHMM,RangedSummarizedExperiment,RangedSummarizedExperiment.-method}
\alias{betaHMM,matrix,data.frame-method}
\alias{betaHMM,matrix,RangedSummarizedExperiment.-method}
\alias{betaHMM,data.frame,matrix-method}
\alias{betaHMM,data.frame,RangedSummarizedExperiment.-method}
\alias{betaHMM,RangedSummarizedExperiment,data.frame-method}
\alias{betaHMM,RangedSummarizedExperiment,matrix-method}
\alias{betaHMM,GRanges,data.frame-method}
\alias{betaHMM,GRanges,matrix-method}
\alias{betaHMM,GRanges,RangedSummarizedExperiment-method}
\alias{betaHMM,GRanges,GRanges-method}
\alias{betaHMM,data.frame,GRanges-method}
\alias{betaHMM,RangedSummarizedExperiment,GRanges-method}
\alias{betaHMM,matrix,GRanges-method}
\alias{betaHMM,RangedSummarizedExperiment,RangedSummarizedExperiment-method}
\alias{betaHMM,matrix,RangedSummarizedExperiment-method}
\alias{betaHMM,data.frame,RangedSummarizedExperiment-method}
\title{HMM for beta valued DNA data}
\usage{
betaHMM(methylation_data, annotation_file, ...)

\S4method{betaHMM}{matrix,matrix}(
  methylation_data,
  annotation_file,
  M = 3,
  N = 4,
  R = 2,
  treatment_group = NULL,
  parallel_process = FALSE,
  seed = NULL,
  iterations = 100,
  ...
)

\S4method{betaHMM}{data.frame,data.frame}(
  methylation_data,
  annotation_file,
  M = 3,
  N = 4,
  R = 2,
  treatment_group = NULL,
  parallel_process = FALSE,
  seed = NULL,
  iterations = 100,
  ...
)

\S4method{betaHMM}{RangedSummarizedExperiment,RangedSummarizedExperiment}(
  methylation_data,
  annotation_file,
  M = 3,
  N = 4,
  R = 2,
  treatment_group = NULL,
  parallel_process = FALSE,
  seed = NULL,
  iterations = 100,
  ...
)

\S4method{betaHMM}{GRanges,GRanges}(
  methylation_data,
  annotation_file,
  M = 3,
  N = 4,
  R = 2,
  treatment_group = NULL,
  parallel_process = FALSE,
  seed = NULL,
  iterations = 100,
  ...
)

\S4method{betaHMM}{RangedSummarizedExperiment,matrix}(
  methylation_data,
  annotation_file,
  M = 3,
  N = 4,
  R = 2,
  treatment_group = NULL,
  parallel_process = FALSE,
  seed = NULL,
  iterations = 100,
  ...
)

\S4method{betaHMM}{RangedSummarizedExperiment,data.frame}(
  methylation_data,
  annotation_file,
  M = 3,
  N = 4,
  R = 2,
  treatment_group = NULL,
  parallel_process = FALSE,
  seed = NULL,
  iterations = 100,
  ...
)

\S4method{betaHMM}{RangedSummarizedExperiment,GRanges}(
  methylation_data,
  annotation_file,
  M = 3,
  N = 4,
  R = 2,
  treatment_group = NULL,
  parallel_process = FALSE,
  seed = NULL,
  iterations = 100,
  ...
)

\S4method{betaHMM}{matrix,RangedSummarizedExperiment}(
  methylation_data,
  annotation_file,
  M = 3,
  N = 4,
  R = 2,
  treatment_group = NULL,
  parallel_process = FALSE,
  seed = NULL,
  iterations = 100,
  ...
)

\S4method{betaHMM}{data.frame,RangedSummarizedExperiment}(
  methylation_data,
  annotation_file,
  M = 3,
  N = 4,
  R = 2,
  treatment_group = NULL,
  parallel_process = FALSE,
  seed = NULL,
  iterations = 100,
  ...
)

\S4method{betaHMM}{data.frame,GRanges}(
  methylation_data,
  annotation_file,
  M = 3,
  N = 4,
  R = 2,
  treatment_group = NULL,
  parallel_process = FALSE,
  seed = NULL,
  iterations = 100,
  ...
)

\S4method{betaHMM}{matrix,data.frame}(
  methylation_data,
  annotation_file,
  M = 3,
  N = 4,
  R = 2,
  treatment_group = NULL,
  parallel_process = FALSE,
  seed = NULL,
  iterations = 100,
  ...
)

\S4method{betaHMM}{matrix,GRanges}(
  methylation_data,
  annotation_file,
  M = 3,
  N = 4,
  R = 2,
  treatment_group = NULL,
  parallel_process = FALSE,
  seed = NULL,
  iterations = 100,
  ...
)

\S4method{betaHMM}{GRanges,matrix}(
  methylation_data,
  annotation_file,
  M = 3,
  N = 4,
  R = 2,
  treatment_group = NULL,
  parallel_process = FALSE,
  seed = NULL,
  iterations = 100,
  ...
)

\S4method{betaHMM}{GRanges,data.frame}(
  methylation_data,
  annotation_file,
  M = 3,
  N = 4,
  R = 2,
  treatment_group = NULL,
  parallel_process = FALSE,
  seed = NULL,
  iterations = 100,
  ...
)

\S4method{betaHMM}{GRanges,RangedSummarizedExperiment}(
  methylation_data,
  annotation_file,
  M = 3,
  N = 4,
  R = 2,
  treatment_group = NULL,
  parallel_process = FALSE,
  seed = NULL,
  iterations = 100,
  ...
)

\S4method{betaHMM}{data.frame,matrix}(
  methylation_data,
  annotation_file,
  M = 3,
  N = 4,
  R = 2,
  treatment_group = NULL,
  parallel_process = FALSE,
  seed = NULL,
  iterations = 100,
  ...
)
}
\arguments{
\item{methylation_data}{A dataframe of dimension \eqn{(C \times (N \times R)
)+1} containing methylation values for \eqn{C} CpG sites from \eqn{R}
treatment groups each having \eqn{N} DNA samples and the IlmnID
for each CpG site. Maybe provided as a matrix or data.frame, GRanges
or RangedSummarizedExperiment object.}

\item{annotation_file}{A dataframe containing the EPIC methylation
annotation file. Maybe provided as a matrix or data.frame, GRanges
or RangedSummarizedExperiment object.}

\item{...}{Extra arguments}

\item{M}{Number of methylation states to be identified in a
single DNA sample.}

\item{N}{Number of DNA samples (patients/replicates) collected for each
treatment group.}

\item{R}{Number of treatment groups (For. eg: Benign and Tumour).}

\item{treatment_group}{The names of each treatment groups/
conditions. If no value is passed then default values of sample names,
e.g. Sample 1, Sample 2, etc are used as legend text (default = NULL).}

\item{parallel_process}{The 'TRUE' option results in parallel processing of
the models for each chromosome for increased computational efficiency.
The default option has been set as 'FALSE' due to package testing
limitations.}

\item{seed}{Seed to allow for reproducibility (default = NULL).}

\item{iterations}{Number of iterations for algorithm convergence
(default=100).}
}
\value{
An S4 object of class \code{betaHMMResults}, where conditional
probabilities of each CpG site belonging to a hidden state is stored as a
SimpleList of assay data, and the corresponding estimated model parameters,
log-likelihood values, and most probable hidden state sequence for each
chromosome are stored as metadata.
}
\description{
This is the primary user interface for the \code{betaHMM} function
Generic S4 methods are implemented to eatimate the parameters of a
homogeneous hidden Markov model for the beta valued DNA methylation data.
The supported classes are \code{matrix}, \code{data.frame},
\code{RangedSummarizedExperiment} and \code{GRanges}. The output of
\code{betaHMM} method is an
S4 object of class \code{betaHMMResults}.
}
\examples{
## Use simulated data for the betaHMM workflow example
set.seed(12345)

## read files
data(sample_methylation_file)
data(sample_annotation_file)
# Run betaHMM function
beta_out <- betaHMM(sample_methylation_file[1:50,],
                    sample_annotation_file[1:50,],
                    M = 3, N = 4, R = 2,iterations=2,
                    parallel_process = FALSE, seed = 12345,
                    treatment_group = c("Benign","Tumour"))

## Run dmc_identification function
dmc_out <- dmc_identification(beta_out)

# Run dmr_identification function
dmr_out <- dmr_identification(dmc_out, parallel_process = FALSE)

# Plot functions
# Get the AUC values calculated for each hidden state
AUC_chr <- AUC(dmc_out)

## plot the uncertainty for each hidden state
plot(beta_out, chromosome = "1", what = "uncertainty")

}
\author{
Koyel Majumdar
}
\keyword{methods}
