% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/threshold_identification.R
\name{threshold_identification_run}
\alias{threshold_identification_run}
\title{Threshold indentification function}
\usage{
threshold_identification_run(
  data,
  package_workflow = TRUE,
  annotation_file = NULL,
  M,
  N,
  parameter_estimation_only = FALSE,
  seed = NULL,
  ...
)
}
\arguments{
\item{data}{Methylation data and IlmnID. Maybe provided as
a matrix or dataframe.}

\item{package_workflow}{Flag set to TRUE if method called from package
workflow.
If set to FALSE then the parameter annotation_file needs to be supplied to
the function.}

\item{annotation_file}{A dataframe containing the EPIC methylation
annotation file.}

\item{M}{Number of methylation states to be identified in a
single DNA sample.}

\item{N}{Number of DNA samples (patients/replicates) collected for each
treatment group.}

\item{parameter_estimation_only}{If only model parameters are to be
estimated then value is TRUE else FALSE.}

\item{seed}{Seed to allow for reproducibility (default = NULL).}

\item{...}{Extra parameters.}
}
\value{
An S4 object of class \code{threshold_Results}, where conditional
probabilities
of each CpG site belonging to a one of the \eqn{M} methylation states
is stored as a SimpleList of
assay data, and the corresponding estimated model parameters, the thresholds
and most probable hidden state sequence for each chromosome are
stored as metadata.
}
\description{
HMM for beta valued DNA data for a single treatment condition
}
\examples{
## Use simulated data for the betaHMM workflow example
set.seed(12345)
library(betaHMM)

## read files
data(sample_methylation_file)
head(sample_methylation_file)
data(sample_annotation_file)
head(sample_annotation_file)
##merge data
df=merge(sample_annotation_file[,c('IlmnID','CHR','MAPINFO')],
sample_methylation_file,by='IlmnID')

## sort data
df=df[order(df$CHR,df$MAPINFO),]
thr_out=threshold_identification(df[,c(1,4:7)],package_workflow=TRUE,M=3,4,
parameter_estimation_only=TRUE,seed=12345)

}
