% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotLine.R
\name{plotLine}
\alias{plotLine}
\title{Line plot}
\usage{
plotLine(
  Y = NULL,
  lmpDataList = NULL,
  rows = 1,
  type = c("l", "p", "s"),
  title = "Line plot",
  xlab = NULL,
  ylab = NULL,
  xaxis_type = c("numeric", "character"),
  stacked = FALSE,
  ncol = 1,
  nrow = NULL,
  facet_label = NULL,
  hline = 0,
  size = 0.5,
  color = NULL,
  shape = 1,
  theme = theme_bw(),
  ang_x_axis = NULL
)
}
\arguments{
\item{Y}{A numerical matrix containing the rows to be drawn. Can be \code{NULL} if \code{lmpDataList} is defined.}

\item{lmpDataList}{If not \code{NULL}, a list with outcomes, design and formula, as outputted by \code{\link{data2LmpDataList}}.}

\item{rows}{A vector with either the row name(s) of the \eqn{Y} matrix to plot (character) or the row index position(s) (integer). Default to 1.}

\item{type}{Type of graph to be drawn: \code{"p"} for point, \code{"l"} for line (default) or \code{"s"} for segment.}

\item{title}{Plot title.}

\item{xlab}{If not \code{NULL}, label for the x-axis.}

\item{ylab}{If not \code{NULL}, label for the y-axis.}

\item{xaxis_type}{The data type of the x-axis: either \code{"numeric"} (default) or \code{"character"}.}

\item{stacked}{Logical. If \code{TRUE}, will draw stacked plots, otherwise will draw separate plots.}

\item{ncol}{If \code{stacked} is \code{FALSE}, the number of columns to represent the separate plots. Default to \code{1}.}

\item{nrow}{If \code{stacked} is \code{FALSE}, the number of rows to represent the separate plots.}

\item{facet_label}{If \code{stacked} is \code{FALSE}, the labels of the separate plots.}

\item{hline}{If not \code{NULL}, draws (a) horizontal line(s), by default at y intercept = 0.}

\item{size}{Argument of length 1 giving the points size (if \code{type} ==\code{ "p"}) or the line size (if \code{type} == \code{"l"} or \code{"s"}).}

\item{color}{If not \code{NULL}, argument of length 1 with possible values: \code{"rows"}, a color name (character) or a numeric value representing a color.}

\item{shape}{The points shape (default = \code{1}) if \code{type} == \code{"p"}.}

\item{theme}{The \code{ggplot2} theme (default: \code{theme_bw()}), see \code{?ggtheme} for more info.}

\item{ang_x_axis}{If not \code{NULL}, rotation angle to rotate the x-axis text (based on the argument \code{axis.text.x} from \code{ggplot2::theme()})}
}
\value{
A \code{ggplot2} line plot.
}
\description{
Generates the response profile of one or more observations i.e. plots of one or more rows of the outcomes matrix on the y-axis against the \eqn{m} response variables on the x-axis. Depending on the response type (spectra, gene expression...), point, line or segment plots can be used.
}
\details{
Either \code{Y} or \code{lmpDataList} need to be defined. If both are given, the priority goes to \code{Y}.
}
\examples{

data("UCH")
plotLine(Y = UCH$outcomes)

plotLine(lmpDataList = UCH)

# separate plots
plotLine(Y = UCH$outcomes, rows = seq(1, 8), hline = NULL)
plotLine(Y = UCH$outcomes, rows = seq(1, 8), color = 2)
plotLine(Y = UCH$outcomes, rows = seq(1, 8), ncol = 2)
plotLine(
  Y = UCH$outcomes, type = "p",
  rows = seq(1, 8), ncol = 2
)

# stacked plots
library(ggplot2)
plotLine(
  Y = UCH$outcomes, rows = seq(1, 1),
  stacked = TRUE, color = "rows"
) +
  scale_color_brewer(palette = "Set1")

}
