% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stability_selection.R
\name{.glmnetRandomizedLasso}
\alias{.glmnetRandomizedLasso}
\title{Randomized Lasso}
\usage{
.glmnetRandomizedLasso(
  x,
  y,
  q,
  weakness = 1,
  type = c("conservative", "anticonservative"),
  ...
)
}
\arguments{
\item{x}{The predictor matrix. Passed to \code{x}
of \code{glmnet.lasso} from \code{stabs} package.}

\item{y}{The response vector. Passed to \code{y}
of \code{glmnet.lasso} from \code{stabs} package.}

\item{q}{The number of variables that are selected on each subsample.
Passed to \code{q} of \code{glmnet.lasso} from \code{stabs} package.}

\item{weakness}{Weakness parameter used in randomized lasso (see details).}

\item{type}{Parameter passed to \code{type} of \code{glmnet.lasso} from
\code{stabs} package. It is a character vector specifying how much the
PFER should be controlled. If type is "conservative" (default), then the
number of selected variables per subsample is <= q. If type is
"anticonservative" then the number of selected variables per subsample
is >= q.}

\item{...}{Additional parameters for \code{glmnet}.}
}
\value{
The regression output which consists of a list of length 2. The
    list contains the following:
    \describe{
    \item{selected}{ - a logical vector of length equal to the total number
        of predictors. The predictors that were chosen have a value of TRUE.}
    \item{path}{ - a logical matrix containing the regularization steps as
        columns and the predictors as rows. An entry of TRUE indicates
        selection.}
    }
}
\description{
This function performs randomized lasso using the \code{glmnet}
    package. The function present in the \code{stabs} package that runs the
    lasso version was adapted for the randomized lasso here. Randomized
    lasso stability selection uses this function repeatedly
    to select predictors.
}
\details{
This function is identical to \code{glmnet.lasso} from the
    \code{stabs} package. The only addition/modification is the weakness
    parameter which has been added when calling the
    \code{glmnet} function by setting
    penalty.factor = 1/runif(ncol(x), weakness, 1),
    where ncol(x) is the number of predictors.
}
\seealso{
\code{\link[stabs]{glmnet.lasso}} and \code{\link[glmnet]{glmnet}}
}
\keyword{internal}
