% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binning.R
\name{getSetZeroBin}
\alias{getSetZeroBin}
\alias{getZeroBin}
\alias{setZeroBin}
\title{Get and set the zero bin manually}
\usage{
getZeroBin(bins)

setZeroBin(bins, zeroBin)
}
\arguments{
\item{bins}{Factor, typically the return value of
\code{\link[monaLisa]{bin}}.}

\item{zeroBin}{Numeric or character scalar indicating the level to use as
the zero bin, or NA.}
}
\value{
For \code{getZeroBin}, the index of the level representing the zero bin.
For \code{setZeroBin}, a modified factor with the zero bin set to the
provided value.
}
\description{
Get and set the zero bin manually
}
\examples{
set.seed(1)
x <- rnorm(100)
bins <- bin(x, "equalN", nElements = 10, minAbsX = 0.5)
getZeroBin(bins)
bins <- setZeroBin(bins, 2)

}
