% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plotStabilityPaths}
\alias{plotStabilityPaths}
\title{Plot Stability Paths}
\usage{
plotStabilityPaths(
  se,
  selProbMin = metadata(se)$stabsel.params.cutoff,
  selColor = "cadetblue",
  notSelColor = "grey",
  selProbCutoffColor = "firebrick",
  linewidth = 0.5,
  alpha = 1,
  ylim = c(0, 1),
  labelPaths = FALSE,
  labels = NULL,
  labelNudgeX = 8,
  labelSize = 3
)
}
\arguments{
\item{se}{The \code{SummarizedExperiment} object resulting from stability
selection, by running \code{\link[monaLisa]{randLassoStabSel}}.}

\item{selProbMin}{A numerical scalar in [0,1]. Predictors with a selection
probability greater than \code{selProbMin} are shown as colored lines. The
color is defined by the \code{col} argument.}

\item{selColor}{Color for the selected predictors which have a selection
probability greater than \code{selProbMin}.}

\item{notSelColor}{Color for the rest of the (un-selected) predictors.}

\item{selProbCutoffColor}{Color for the line depicting the selection
probability cutoff.}

\item{linewidth}{Line width.}

\item{alpha}{Line transparency of the stability paths.}

\item{ylim}{Limits for y-axis.}

\item{labelPaths}{If \code{TRUE}, the predictor labels will be shown at the
end of the stability paths. The predictor labels given in \code{labels}
will be shown. If unspecified, the labels corresponding to the selected
predictors will be added. If predictors have the same y-value in the last
regularization step, the labels will be shown in a random order. One
needs to use \code{set.seed} to reproduce the plot in this case.}

\item{labels}{If \code{labelPaths = TRUE}, the predictors which should be
labelled. If \code{NULL}, the selected predictors greater than
\code{metadata(se)$stabsel.params.cutoff} will be shown.}

\item{labelNudgeX}{If \code{labelPaths = TRUE}, how much to nudge the labels
to the right of the x-axis.}

\item{labelSize}{If \code{labelPaths = TRUE}, the size of the labels.}
}
\value{
a \code{ggplot2} object.
}
\description{
Plot the stability paths of each variable (predictor),
  showing the selection probability as a function of the regularization step.
}
\examples{
## create data set
Y <- rnorm(n = 500, mean = 2, sd = 1)
X <- matrix(data = NA, nrow = length(Y), ncol = 50)
for (i in seq_len(ncol(X))) {
  X[ ,i] <- runif(n = 500, min = 0, max = 3)
}
s_cols <- sample(x = seq_len(ncol(X)), size = 10,
  replace = FALSE)
for (i in seq_along(s_cols)) {
  X[ ,s_cols[i]] <- X[ ,s_cols[i]] + Y
}

## reproducible randLassoStabSel() with 1 core
set.seed(123)
ss <- randLassoStabSel(x = X, y = Y)
plotStabilityPaths(ss)

}
\seealso{
\code{\link[stabs]{stabsel}}
}
