% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peakPantheR.R
\docType{package}
\name{peakPantheR}
\alias{peakPantheR}
\alias{peakPantheR-package}
\title{peakPantheR: A package for Peak Picking and ANnoTation of High resolution
Experiments}
\description{
\pkg{peakPantheR} detects, integrates and reports pre-defined features in
mass spectrometry data files. It enables the real time annotation of multiple
compounds in a single file, or the parallel annotation of multiple compounds
in multiple files.
}
\details{
The main functions of \pkg{peakPantheR} are
\code{\link{peakPantheR_singleFileSearch}} for realtime annotation, and
\code{\link{peakPantheR_parallelAnnotation}} for parallel annotation. The
\code{peakPantheRAnnotation} object stores parallel annotation results, while
reporting functions help assess the quality of annotation and update
fitting parameters. Refer to the vignettes for graphical user interface and
command line tutorials.
}
\seealso{
Useful links:
\itemize{
    \item \url{https://github.com/phenomecentre/peakPantheR}
    \item Report bugs at
    \url{https://github.com/phenomecentre/peakPantheR/issues/new}
}

}
\author{
\strong{Maintainer}: Arnaud Wolfer \email{adwolfer@gmail.com}
    (\href{https://orcid.org/0000-0001-5856-3218}{ORCID})

Authors:
\itemize{
    \item Goncalo Correia \email{gscorreia89@gmail.com}
        (\href{https://orcid.org/0000-0001-8271-9294}{ORCID})
}

Other contributors:
\itemize{
    \item Jake Pearce \email{jake.pearce@gmail.com} [contributor]
    \item Caroline Sands \email{caz119@hotmail.co.uk} [contributor]
}

}
