% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peakPantheR_quickEIC.R
\name{peakPantheR_quickEIC}
\alias{peakPantheR_quickEIC}
\title{Extract and plot a EIC from a raw data file}
\usage{
peakPantheR_quickEIC(
    spectraPath,
    rt,
    mz,
    valuesOnly = "Plot",
    centroided = TRUE,
    msLevel = 1L,
    verbose = TRUE
)
}
\arguments{
\item{spectraPath}{(str) Path to the raw data file to read (uses 
`MSnbase::readMSData()`)}

\item{rt}{(numeric(2) or two-column matrix) the lower and upper retention
time range from which the data should be extracted. If a matrix is passed,
each row corresponds to a different window. If not provided, the full
retention time range will be extracted.}

\item{mz}{(numeric(2) or two-column matrix) the lower and upper mass range
from which the data should be extracted. If a matrix is passed, each row
corresponds to a different window. If not provided, the full mass range will
be extracted.}

\item{valuesOnly}{(str) If 'Raw' only load the file and return a table of raw
extracted values (exported version of `extractSignalRawData()`). If `EIC`
return a table of EIC data point. Else return the EIC plot (default).}

\item{centroided}{(bool) Indicate to `MSnbase::readMSData()` whether the spectra
file is centroided or not (default to 'TRUE').}

\item{msLevel}{(int) The MS level at which the data should be extracted 
(default to MS level 1).}

\item{verbose}{(bool) Output proress information or not.}
}
\value{
Grob (ggplot object) of the EIC plot, if `valuesOnly='Raw'` returns 
a data.frame of raw datapoints with as columns 'rt', 'mz' and 'int'. If 
`valuesOnly='EIC'` returns a data.frame of EIC datapoints with as columns 
'rt' and 'int'.
}
\description{
Simple plot of an Extracted Ion Chromatogram (EIC) from a raw 
data file and a provided mz and rt window. Return ggplot plot object.
}
\examples{
## Use a file form the faahKO package and plot an EIC of interest
library(faahKO)
spectraPath <- system.file('cdf/KO/ko15.CDF',package='faahKO')
peakPantheR_quickEIC(spectraPath,
                        rt = c(3290., 3410.),
                        mz = c(522.194778, 522.205222))
}
