% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pgxMetaplot.R
\name{pgxMetaplot}
\alias{pgxMetaplot}
\title{Plot survival data of individuals}
\usage{
pgxMetaplot(data, group_id, condition, return_data = FALSE, ...)
}
\arguments{
\item{data}{The data frame returned by the \code{pgxLoader} function, containing survival data for individuals.
The survival state is represented by Experimental Factor Ontology in the "followup_state_id" column,
and the survival time is represented in ISO 8601 duration format in the "followup_time" column.}

\item{group_id}{A string specifying which column is used for grouping in the Kaplan-Meier plot.}

\item{condition}{A string for splitting individuals into younger and older groups,
following the ISO 8601 duration format. Only used if \code{group_id} is "age_iso".}

\item{return_data}{A logical value determining whether to return the metadata used for plotting. Default is FALSE.}

\item{...}{Other parameters relevant to KM plot. These include \code{pval}, \code{pval.coord}, \code{pval.method}, \code{conf.int}, \code{linetype}, and \code{palette} (see ggsurvplot from survminer)}
}
\value{
The KM plot from input data
}
\description{
This function provides the survival plot from individual metadata.
}
\examples{
individuals <- pgxLoader(type="individuals",filters="NCIT:C3512")
pgxMetaplot(individuals, group_id="age_iso", condition="P65Y")
}
